package com.clx.performance.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.constant.RabbitKeyIntegralConstants;
import com.clx.performance.param.mq.IntegralTuckAddMqParam;
import com.clx.performance.service.IntegralMqHandlerService;
import com.clx.performance.common.MqWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 积分车辆新增 mq
 * @Date: 2023-10-12 19:27:49
 * @Version: 1.0
 */
@Slf4j
@Component
public class IntegralTruckAddListener {

    @Autowired
    private IntegralMqHandlerService integralMqHandlerService;

    @RabbitListener(queues = RabbitKeyIntegralConstants.INTEGRAL_TRUCK_ADD_QUEUE)
    public void process(Message message) {
        try{
            log.info("司机积分-新增车辆, message:{}", new String(message.getBody()));
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<IntegralTuckAddMqParam>>(){}).getData());
        }catch (Exception e){
            log.info("司机积分-新增车辆 失败",e);
        }
    }

    private void process(IntegralTuckAddMqParam mq){

        integralMqHandlerService.truckAdd(mq);

    }
}
