package com.clx.performance.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * 硬件设备redis配置
 *
 * @author wanglq
 * Date 2023/7/20
 * Time 11:56
 */
@Configuration
@ConfigurationProperties(prefix = "device.redis")
@Getter
@Setter
public class DeviceRedisConfig {
    private String type = "single";
    private String password;
    private String nodes;

    public boolean isCluster() {
        return "cluster".equals(type);
    }
}
