package com.clx.performance.param.app.collect;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Getter
@Setter
@NoArgsConstructor
public class CollectTruckLocationSaveParam {

    @ApiModelProperty(value = "车牌号", example = "京A12345")
    @NotBlank(message = "车牌号不能为空")
    private String truckNo;

    @ApiModelProperty(value = "车辆出车状态 1:空车 2重车", example = "1")
    @NotNull(message = "车辆出车状态不能空")
    private Integer truckOrderStatus;

    @ApiModelProperty(value = "经度")
    private BigDecimal longitude;
    @ApiModelProperty(value = "纬度")
    private BigDecimal latitude;

    @ApiModelProperty(value = "省", example = "")
    private String province;
    @ApiModelProperty(value = "市", example = "")
    private String city;
    @ApiModelProperty(value = "区县", example = "")
    private String county;
    @ApiModelProperty(value = "乡镇", example = "")
    private String town;
    @ApiModelProperty(value = "街道", example = "")
    private String street;
    @ApiModelProperty(value = "详细地址", example = "北京路1号")
    private String address;
    @ApiModelProperty(value = "司机手填地址", example = "北京路1号")
    private String locationRemark;

}
