package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OrderGoodsPendingOrderWayStatusEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {

        OPEN(1, "公开派单"),

        EXCLUSIVE(2, "定向派单"),
        ;

        private final Integer code;
        private final String name;

        public static Optional<Status> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }
    }


}
