package com.clx.performance.dao.impl.settle;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
import com.clx.performance.mapper.settle.SettlementOwnerDetailMapper;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PageOwnerSettlementOwnerDetailParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Objects;

/**
 * @Author: aiqinguo
 * @Description: 货主运单计费明细
 * @Date: 2023-10-11 18:04:09
 * @Version: 1.0
 */
@Repository
public class SettlementOwnerDetailDaoImpl extends BaseDaoImpl<SettlementOwnerDetailMapper, SettlementOwnerDetail, Integer> implements SettlementOwnerDetailDao {

    @Override
    public boolean updateInvoiceType(SettlementOwnerDetail item) {
        return update(lUdWrapper()
                .eq(SettlementOwnerDetail::getId, item.getId())
                .set(SettlementOwnerDetail::getInvoiceType, item.getInvoiceType())
                .set(SettlementOwnerDetail::getPrepayFreight, item.getPrepayFreight())
        );
    }

    @Override
    public boolean updateSettlementNo(SettlementOwnerDetail item) {
        return update(lUdWrapper()
                .eq(SettlementOwnerDetail::getId, item.getId())
                .set(SettlementOwnerDetail::getSettlementNo, item.getSettlementNo())
        );
    }

    @Override
    public boolean updateInvoiceStatusBySettlementNo(String settlementNo, Integer invoiceStatus){
        return update(lUdWrapper()
                .eq(SettlementOwnerDetail::getSettlementNo, settlementNo)
                .set(SettlementOwnerDetail::getInvoiceStatus, invoiceStatus)
        );
    }

    @Override
    public boolean updateFinalPaymentStatusBySettlementNo(String settlementNo, Integer finalPaymentStatus){
        return update(lUdWrapper()
                .eq(SettlementOwnerDetail::getSettlementNo, settlementNo)
                .set(SettlementOwnerDetail::getFinalPaymentStatus, finalPaymentStatus)
        );
    }

    @Override
    public Optional<SettlementOwnerDetail> getByChildNo(String childNo) {
        return Optional.of(childNo)
                .map(item -> lQrWrapper()
                        .eq(SettlementOwnerDetail::getChildNo, item)
                )
                .map(super::getOne);
    }
    @Override
    public List<SettlementOwnerDetail> getBySettlementNo(String settlementNo) {
        return list(lQrWrapper().eq(SettlementOwnerDetail::getSettlementNo, settlementNo));
    }


    @Override
    public IPage<SettlementOwnerDetail> pageSettlementOwnerDetail(
            PageCarrierSettlementOwnerDetailParam param) {
        LambdaQueryWrapper<SettlementOwnerDetail> query = new LambdaQueryWrapper<>();
        if(StringUtils.isNotBlank(param.getChildNo())){
            query.eq(SettlementOwnerDetail :: getChildNo,param.getChildNo());
        }
        if(StringUtils.isNotBlank(param.getOrderNo())){
            query.eq(SettlementOwnerDetail :: getOrderNo,param.getOrderNo());
        }
        if(Objects.nonNull(param.getOwnerUserNo())){
            query.eq(SettlementOwnerDetail :: getOwnerUserNo,param.getOwnerUserNo());
        }
        if(Objects.nonNull(param.getOwnerUserName())){
            query.like(SettlementOwnerDetail :: getOwnerName,param.getOwnerUserName());
        }
        query.orderByDesc(SettlementOwnerDetail ::getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }

    @Override
    public IPage<SettlementOwnerDetail> pageOwnerSettlementOrderDetailList(PageOwnerSettlementOwnerDetailParam param) {
        LambdaQueryWrapper<SettlementOwnerDetail> query = new LambdaQueryWrapper<>();
        query.eq(SettlementOwnerDetail :: getSettlementNo,param.getSettlementNo());
        query.eq(StringUtils.isNotBlank(param.getChildNo()),SettlementOwnerDetail :: getChildNo,param.getChildNo());
        query.eq(StringUtils.isNotBlank(param.getOrderNo()),SettlementOwnerDetail :: getOrderNo,param.getOrderNo());
        query.eq(StringUtils.isNotBlank(param.getSettlementSubNo()),SettlementOwnerDetail :: getSettlementSubNo,param.getSettlementSubNo());
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }
}
