/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.oscca.encryption;

import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.oscca.encryption.SM4;

public class SM4ECB
extends SM4 {
    private int mod = 0;
    public static int ENC_MOD = 1;
    public static int DEC_MOD = 2;
    private byte[] key;
    private int[] rkey = new int[32];
    private byte[] remainData = new byte[0];
    byte[] tr = new byte[16];

    public SM4ECB(int mod) {
        this.mod = mod;
    }

    public void init(byte[] key) throws CryptoException {
        if (key.length < 16) {
            throw new CryptoException("Invalid SM4 key length:" + key.length + " must be 16");
        }
        this.key = new byte[16];
        System.arraycopy(key, 0, this.key, 0, 16);
        this.rkey = new int[32];
        SM4ECB.sm4_key_exp(key, this.rkey);
        this.remainData = new byte[0];
    }

    public byte[] update(byte[] in, int offset, int length) {
        byte[] tmp = new byte[length];
        System.arraycopy(in, offset, tmp, 0, length);
        return this.update(tmp);
    }

    public byte[] update(byte[] in) {
        if (this.mod == ENC_MOD) {
            return this.encryptUpdate(in);
        }
        return this.decryptUpdate(in);
    }

    private byte[] decryptFinal() throws CryptoException {
        if (this.remainData.length % 16 != 0) {
            throw new CryptoException("decrypt failed");
        }
        int in_len_bytes = this.remainData.length;
        int numBlocks = in_len_bytes / 16;
        byte[] out = new byte[numBlocks * 16];
        int i = 0;
        while (i < numBlocks) {
            System.arraycopy(this.remainData, i * 16, this.tr, 0, 16);
            byte[] ivTmp = new byte[16];
            System.arraycopy(this.tr, 0, ivTmp, 0, 16);
            SM4ECB.sm4_decrypt_rk(this.tr, this.rkey, this.tr);
            System.arraycopy(this.tr, 0, out, i * 16, 16);
            ++i;
        }
        byte[] rt = new byte[out.length - out[out.length - 1]];
        System.arraycopy(out, 0, rt, 0, rt.length);
        return rt;
    }

    private byte[] decryptUpdate(byte[] in) {
        int in_len_bytes = this.remainData.length + in.length;
        if (in_len_bytes < 16) {
            byte[] tmp = new byte[in_len_bytes];
            System.arraycopy(this.remainData, 0, tmp, 0, this.remainData.length);
            System.arraycopy(in, 0, tmp, this.remainData.length, in.length);
            this.remainData = tmp;
            return new byte[0];
        }
        int numBlocks = in_len_bytes / 16;
        numBlocks = numBlocks > 0 ? numBlocks - 1 : 0;
        int remainLength = in_len_bytes - numBlocks * 16;
        byte[] out = new byte[numBlocks * 16];
        int i = 0;
        while (i < numBlocks) {
            if (i == 0) {
                if (this.remainData.length > 16) {
                    System.arraycopy(this.remainData, 0, this.tr, 0, 16);
                } else {
                    System.arraycopy(this.remainData, 0, this.tr, 0, this.remainData.length);
                    System.arraycopy(in, 0, this.tr, this.remainData.length, 16 - this.remainData.length);
                }
            } else if (i == 1) {
                if (this.remainData.length > 16) {
                    System.arraycopy(this.remainData, 16, this.tr, 0, this.remainData.length - 16);
                    System.arraycopy(in, 0, this.tr, this.remainData.length - 16, 32 - this.remainData.length);
                } else {
                    System.arraycopy(in, i * 16 - this.remainData.length, this.tr, 0, 16);
                }
            } else {
                System.arraycopy(in, i * 16 - this.remainData.length, this.tr, 0, 16);
            }
            SM4ECB.sm4_decrypt_rk(this.tr, this.rkey, this.tr);
            System.arraycopy(this.tr, 0, out, i * 16, 16);
            ++i;
        }
        this.remainData = new byte[remainLength];
        System.arraycopy(in, in.length - remainLength, this.remainData, 0, remainLength);
        return out;
    }

    private byte[] encryptUpdate(byte[] in) {
        int in_len_bytes = this.remainData.length + in.length;
        int numBlocks = in_len_bytes / 16;
        int remainLength = in_len_bytes % 16;
        byte[] out = new byte[numBlocks * 16];
        int i = 0;
        while (i < numBlocks) {
            if (i == 0) {
                System.arraycopy(this.remainData, 0, this.tr, 0, this.remainData.length);
                System.arraycopy(in, 0, this.tr, this.remainData.length, 16 - this.remainData.length);
            } else {
                System.arraycopy(in, i * 16 - this.remainData.length, this.tr, 0, 16);
            }
            SM4ECB.sm4_encrypt_rk(this.tr, this.rkey, this.tr);
            System.arraycopy(this.tr, 0, out, i * 16, 16);
            ++i;
        }
        this.remainData = new byte[remainLength];
        System.arraycopy(in, in.length - remainLength, this.remainData, 0, remainLength);
        return out;
    }

    public byte[] doFinal() throws CryptoException {
        if (this.mod == ENC_MOD) {
            return this.encryptFinal();
        }
        return this.decryptFinal();
    }

    private byte[] encryptFinal() {
        int l = 16 - this.remainData.length;
        System.arraycopy(this.remainData, 0, this.tr, 0, this.remainData.length);
        int i = this.remainData.length;
        while (i < 16) {
            this.tr[i] = (byte)l;
            ++i;
        }
        byte[] out = new byte[16];
        SM4ECB.sm4_encrypt_rk(this.tr, this.rkey, out);
        return out;
    }
}

