/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.logger;

import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConsoleLogger {
    private static Date now;
    private static SimpleDateFormat format;
    public static boolean isPrintST;
    public static boolean isDebug;
    public static boolean isSave;
    static /* synthetic */ Class class$0;

    static {
        isPrintST = true;
        isDebug = false;
        isSave = false;
        now = new Date();
        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static void logException(Throwable e, String info) {
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        System.out.println("---------------NetSign(" + time + ")----------------");
        System.out.println(info);
        System.out.println("An exception catched: " + e.toString());
        if (isPrintST) {
            System.out.println("Full stacktrace as below:");
            e.printStackTrace();
        }
        System.out.println("-----------------------------------------------------------");
    }

    public static void logException(Throwable e) {
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        System.out.println("---------------NetSign(" + time + ")----------------");
        System.out.println("An Exception catched:" + e.toString());
        if (isPrintST) {
            System.out.println("Full stacktrace as below:");
            e.printStackTrace();
        }
        System.out.println("----------------------------------------------------------");
    }

    public static void logBinary(String title, byte[] bs) {
        if (!isDebug) {
            return;
        }
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        System.out.println("---------------NetSign(" + time + ")----------------");
        System.out.print(ConsoleLogger.getCodeLine());
        System.out.println(String.valueOf(title) + "(" + bs.length + "):");
        int i = 0;
        int length = bs.length;
        while (i < length) {
            int x = bs[i] & 0xFF;
            if (x > 15) {
                System.out.print(String.valueOf(Integer.toString(x, 16)) + " ");
            } else {
                System.out.print("0" + Integer.toString(x, 16) + " ");
            }
            if ((i + 1) % 16 == 0) {
                System.out.print("\n");
            }
            ++i;
        }
        if (bs.length % 16 != 0) {
            System.out.print("\n");
        }
        System.out.println("----------------------------------------------------------");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveBinary(String file, byte[] bs) {
        block9: {
            if (ConsoleLogger.isSave == false) return;
            ConsoleLogger.now.setTime(System.currentTimeMillis());
            time = ConsoleLogger.format.format(ConsoleLogger.now);
            System.out.println("---------------NetSign(" + time + ")----------------");
            System.out.println("Binary stream saved to file:" + file);
            out = null;
            try {
                try {
                    out = new FileOutputStream(file);
                    out.write(bs);
                    out.flush();
                }
                catch (Exception e) {
                    ConsoleLogger.logException(e);
                }
            }
            catch (Throwable var6_5) {
                var5_6 = null;
                try {
                    if (out == null) throw var6_5;
                    out.close();
                    throw var6_5;
                }
                catch (Exception var7_8) {
                    // empty catch block
                }
                throw var6_5;
            }
            {
                var5_7 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 117->128)] { 
lbl28:
            // 1 sources

            if (out != null) {
                out.close();
            }
            break block9;
lbl31:
            // 1 sources

            catch (Exception var7_9) {
                // empty catch block
            }
        }
        System.out.println("----------------------------------------------------------");
    }

    public static void logStringForce(String msg) {
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        StringBuffer buf = new StringBuffer();
        buf.append("---------------NetSign(").append(time).append(")----------------\n");
        buf.append(ConsoleLogger.getCodeLine());
        buf.append(msg).append("\n");
        buf.append("----------------------------------------------------------\n");
        System.out.print(buf.toString());
    }

    public static void logString(String msg) {
        if (!isDebug) {
            return;
        }
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        StringBuffer buf = new StringBuffer();
        buf.append("---------------NetSign(").append(time).append(")----------------\n");
        buf.append(ConsoleLogger.getCodeLine());
        buf.append(msg).append("\n");
        buf.append("----------------------------------------------------------\n");
        System.out.print(buf.toString());
    }

    private static String getCodeLine() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement stack4Log = null;
        int i = 1;
        while (i < stackTrace.length) {
            stack4Log = stackTrace[i];
            String string = stack4Log.getClassName();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("cn.com.infosec.netsign.logger.ConsoleLogger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (string.indexOf(clazz.getName()) < 0) break;
            ++i;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(stack4Log.getClassName()).append(".").append(stack4Log.getMethodName()).append("(" + stack4Log.getFileName()).append(":").append(String.valueOf(stack4Log.getLineNumber()) + ")").append("\n");
        return buf.toString();
    }
}

