/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.apksign;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.crypto.util.SM3;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class ApkSignUtil {
    private static X509Certificate readPublicKey(File file) throws IOException, GeneralSecurityException {
        X509Certificate x509Certificate;
        FileInputStream input = new FileInputStream(file);
        try {
            X509Certificate x509Certificate2;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            x509Certificate = x509Certificate2 = (X509Certificate)cf.generateCertificate(input);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            input.close();
            throw throwable;
        }
        input.close();
        return x509Certificate;
    }

    private static String readPassword(File keyFile) {
        System.out.print("Enter password for " + keyFile + " (password will not be hidden): ");
        System.out.flush();
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            return stdin.readLine();
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static KeySpec decryptPrivateKey(byte[] encryptedPrivateKey, File keyFile) throws GeneralSecurityException {
        EncryptedPrivateKeyInfo epkInfo;
        try {
            epkInfo = new EncryptedPrivateKeyInfo(encryptedPrivateKey);
        }
        catch (IOException ex) {
            return null;
        }
        char[] password = ApkSignUtil.readPassword(keyFile).toCharArray();
        SecretKeyFactory skFactory = SecretKeyFactory.getInstance(epkInfo.getAlgName());
        SecretKey key = skFactory.generateSecret(new PBEKeySpec(password));
        Cipher cipher = Cipher.getInstance(epkInfo.getAlgName());
        cipher.init(2, (Key)key, epkInfo.getAlgParameters());
        try {
            return epkInfo.getKeySpec(cipher);
        }
        catch (InvalidKeySpecException ex) {
            System.err.println("signapk: Password for " + keyFile + " may be bad.");
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PrivateKey readPrivateKey(File file) throws IOException, GeneralSecurityException {
        PrivateKey privateKey2;
        DataInputStream input = new DataInputStream(new FileInputStream(file));
        try {
            byte[] bytes = new byte[(int)file.length()];
            input.read(bytes);
            KeySpec spec = ApkSignUtil.decryptPrivateKey(bytes, file);
            if (spec == null) {
                spec = new PKCS8EncodedKeySpec(bytes);
            }
            try {
                PrivateKey privateKey;
                privateKey2 = privateKey = KeyFactory.getInstance("RSA").generatePrivate(spec);
            }
            catch (InvalidKeySpecException ex) {
                PrivateKey privateKey4 = KeyFactory.getInstance("DSA").generatePrivate(spec);
                input.close();
                PrivateKey privateKey3 = privateKey4;
                Object var6_9 = null;
                input.close();
                return privateKey3;
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            input.close();
            throw throwable;
        }
        input.close();
        return privateKey2;
    }

    public static Manifest addDigestsToManifest(JarFile jar, String digestAlg) throws IOException, GeneralSecurityException {
        if (digestAlg == null) {
            digestAlg = "SHA1";
        }
        Manifest input = jar.getManifest();
        Manifest output = new Manifest();
        Attributes main = output.getMainAttributes();
        if (input != null) {
            main.putAll((Map<?, ?>)input.getMainAttributes());
            main.putValue("Manifest-Version", "1.0");
            main.putValue("Created-By", "Infosec NetSignServer v5.5.40.12");
        } else {
            main.putValue("Manifest-Version", "1.0");
            main.putValue("Created-By", "Infosec NetSignServer v5.5.40.12");
        }
        byte[] buffer = new byte[4096];
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            int num;
            Object md;
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            if (entry.isDirectory() || name.equals("META-INF/MANIFEST.MF")) continue;
            InputStream data = jar.getInputStream(entry);
            byte[] digest = null;
            if (!digestAlg.equals("SM3")) {
                md = MessageDigest.getInstance(digestAlg, "INFOSEC");
                while ((num = data.read(buffer)) > 0) {
                    ((MessageDigest)md).update(buffer, 0, num);
                }
                digest = ((MessageDigest)md).digest();
            } else {
                md = new SM3();
                while ((num = data.read(buffer)) > 0) {
                    ((SM3)md).update(buffer, 0, num);
                }
                digest = new byte[((SM3)md).getDigestLength()];
                ((SM3)md).digest(digest);
            }
            Attributes attr = null;
            if (input != null) {
                attr = input.getAttributes(name);
            }
            attr = attr != null ? new Attributes(attr) : new Attributes();
            attr.putValue(String.valueOf(digestAlg) + "-Digest", Base64.encode(digest));
            output.getEntries().put(name, attr);
        }
        return output;
    }

    public static void main(String[] args) throws Exception {
        String file = "D:\\TEMP\\testapk\\app-release-signed2.apk";
        String outfile = "D:\\TEMP\\testapk\\app-release-signed3.apk";
        JarFile jar = new JarFile(file);
        JarOutputStream out = new JarOutputStream(new FileOutputStream(outfile));
        out.setLevel(9);
        ApkSignUtil.copyAllFiles(jar, out);
        out.close();
    }

    private static byte[] digest(byte[] plain, String digestAlg) throws Exception {
        if (digestAlg.equals("SM3")) {
            return SM3.SM3Digest(plain);
        }
        MessageDigest md = MessageDigest.getInstance(digestAlg, "INFOSEC");
        return md.digest(plain);
    }

    public static void writeSignatureFile(Manifest manifest, OutputStream out, String digestAlg) throws Exception {
        if (digestAlg == null) {
            digestAlg = "SHA1";
        }
        ByteArrayOutputStream innerOut = new ByteArrayOutputStream();
        PrintStream print = new PrintStream((OutputStream)innerOut, true, "UTF-8");
        manifest.write(print);
        print.flush();
        String dm = Base64.encode(ApkSignUtil.digest(innerOut.toByteArray(), digestAlg));
        Manifest sf = new Manifest();
        Attributes main = sf.getMainAttributes();
        main.putValue("Signature-Version", "1.0");
        main.putValue("Created-By", "Infosec NetSignServer v5.5.40.12");
        main.putValue(String.valueOf(digestAlg) + "-Digest-Manifest", dm);
        Map<String, Attributes> entries = manifest.getEntries();
        Iterator<Map.Entry<String, Attributes>> entrySet = entries.entrySet().iterator();
        while (entrySet.hasNext()) {
            innerOut = new ByteArrayOutputStream();
            print = new PrintStream((OutputStream)innerOut, true, "UTF-8");
            Map.Entry<String, Attributes> entry = entrySet.next();
            print.print("Name: " + entry.getKey() + "\r\n");
            Iterator<Map.Entry<Object, Object>> entryEntrySet = entry.getValue().entrySet().iterator();
            while (entryEntrySet.hasNext()) {
                Map.Entry<Object, Object> entryEntry = entryEntrySet.next();
                print.print(entryEntry.getKey() + ": " + entryEntry.getValue() + "\r\n");
            }
            print.print("\r\n");
            print.flush();
            Attributes sfAttr = new Attributes();
            sfAttr.putValue(String.valueOf(digestAlg) + "-Digest", Base64.encode(ApkSignUtil.digest(innerOut.toByteArray(), digestAlg)));
            sf.getEntries().put(entry.getKey(), sfAttr);
        }
        sf.write(out);
    }

    public static void writeSignatureBlock(Signature signature, X509Certificate publicKey, OutputStream out) throws IOException, GeneralSecurityException {
    }

    public static void copyFiles(Manifest manifest, JarFile in, JarOutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        Iterator<String> keys = manifest.getEntries().keySet().iterator();
        while (keys.hasNext()) {
            int num;
            String name = keys.next();
            JarEntry inEntry = in.getJarEntry(name);
            if (inEntry.getMethod() == 0) {
                out.putNextEntry(new JarEntry(inEntry));
            } else {
                out.putNextEntry(new JarEntry(name));
            }
            InputStream data = in.getInputStream(inEntry);
            while ((num = data.read(buffer)) > 0) {
                out.write(buffer, 0, num);
            }
            out.flush();
        }
    }

    public static void copyAllFiles(JarFile in, JarOutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        Enumeration<JarEntry> e = in.entries();
        while (e.hasMoreElements()) {
            int num = 0;
            JarEntry inEntry = e.nextElement();
            String name = inEntry.getName();
            if (inEntry.getMethod() == 0) {
                out.putNextEntry(new JarEntry(inEntry));
            } else {
                out.putNextEntry(new JarEntry(name));
            }
            System.out.println(String.valueOf(name) + " size:" + inEntry.getSize() + " compressedsize:" + inEntry.getCompressedSize());
            InputStream data = in.getInputStream(inEntry);
            while ((num = data.read(buffer)) > 0) {
                out.write(buffer, 0, num);
            }
            out.flush();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main2(String[] args) {
        Security.addProvider((Provider)new InfosecProvider());
        args = new String[4];
        args[2] = "D:\\TEMP\\testapk\\app-release-unsigned.apk";
        args[3] = "D:\\TEMP\\testapk\\app-release-signed2.apk";
        ZipFile inputJar = null;
        ZipOutputStream outputJar = null;
        try {
            try {
                inputJar = new JarFile(new File(args[2]), false);
                outputJar = new JarOutputStream(new FileOutputStream(args[3]));
                outputJar.setLevel(9);
                Manifest manifest = ApkSignUtil.addDigestsToManifest((JarFile)inputJar, "SHA1");
                manifest.getEntries().remove("META-INF/CERT.SF");
                manifest.getEntries().remove("META-INF/CERT.RSA");
                outputJar.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
                manifest.write(outputJar);
                outputJar.putNextEntry(new JarEntry("META-INF/CERT.SF"));
                ApkSignUtil.writeSignatureFile(manifest, new SignatureOutputStream(outputJar, null), "SHA1");
                outputJar.putNextEntry(new JarEntry("META-INF/CERT.RSA"));
                ApkSignUtil.copyFiles(manifest, (JarFile)inputJar, (JarOutputStream)outputJar);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                if (inputJar != null) {
                    inputJar.close();
                }
                if (outputJar == null) throw throwable;
                outputJar.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        try {}
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        if (inputJar != null) {
            inputJar.close();
        }
        if (outputJar == null) return;
        outputJar.close();
    }

    private static class SignatureOutputStream
    extends FilterOutputStream {
        private Signature mSignature;

        public SignatureOutputStream(OutputStream out, Signature sig) {
            super(out);
            this.mSignature = sig;
        }

        public void write(int b) throws IOException {
            super.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
        }
    }
}

