/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.GenericCertificate;
import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.PBCAgent2G;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public class testPBC2G {
    public static void main(String[] args) throws Exception {
        testPBC2G.testRAW();
    }

    private static void testDigest() throws Exception {
        PBCAgent2G agent = new PBCAgent2G();
        agent.openSignServer("10.20.89.240", 10001, "11111111");
        String digest = agent.messageDigest("11111111".getBytes(), "SHA1");
        System.out.println(digest);
        digest = agent.messageDigest("11111111".getBytes(), "SHA256");
        System.out.println(digest);
        digest = agent.messageDigest("11111111".getBytes(), "SM3");
        System.out.println(digest);
        agent.closeSignServer();
    }

    private static void testPCAC() throws Exception {
        String certid = "5year";
        String encAlg = "AES";
        PBCAgent2G agent1 = new PBCAgent2G();
        agent1.openSignServer("10.20.89.240", "10001", "11111111");
        byte[] plain1 = "12312323foijsdfwqwqef".getBytes();
        byte[][] plain = new byte[][]{plain1};
        System.out.println(System.currentTimeMillis());
        String[] envelope = agent1.makePCACEnvelope(plain, certid, encAlg);
        System.out.println(System.currentTimeMillis());
        System.out.println("ret:" + agent1.getReturnCode());
        System.out.println("encedkey:" + envelope[0]);
        int i = 1;
        while (i < envelope.length) {
            System.out.println("encedmsg(" + i + "):" + envelope[i]);
            ++i;
        }
        byte[][] deced = agent1.decryptPCACEnvelope(envelope, certid, encAlg);
        System.out.println("ret:" + agent1.getReturnCode());
        int i2 = 0;
        while (i2 < deced.length) {
            System.out.println("plain(" + (i2 + 1) + "):" + new String(deced[i2]));
            if (!Arrays.equals(deced[i2], plain[i2])) {
                System.out.print("decrypt failed");
                System.exit(0);
            }
            ++i2;
        }
        agent1.closeSignServer();
    }

    private static void testSignHash() throws Exception {
        PBCAgent2G agent1 = new PBCAgent2G();
        agent1.openSignServer("10.20.89.240", "10001", "11111111");
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] digest = md.digest("11111111".getBytes());
        String signed = agent1.rawSignHash(digest, "CN=5year,O=syn080924,C=cn", "SHA1");
        System.out.println(signed);
        boolean verify = agent1.rawVerifyHash(digest, signed, "CN=5year,O=syn080924,C=cn", "SHA1");
        System.out.println("verify:" + verify);
    }

    private static void testGetServerInfo() {
        PBCAgent2G agent1 = new PBCAgent2G();
        agent1.openSignServer("10.20.89.163", "10001", "11111111");
        System.out.println(agent1.getServerInfo("cavium"));
        System.out.println(agent1.getReturnCode());
    }

    private static void testWangLianEnvelopeCMB() {
        String certid = "C=cn,ST=GuangDong,L=ShenZhen,O=CMB,OU=IT,CN=C1030844001362";
        PBCAgent2G agent1 = new PBCAgent2G();
        agent1.openSignServer("10.20.89.240", "10001", "11111111");
        String[] envelope = new String[]{"EIOuacPzkBhMJSk/HJESvsBTjM/5IGadqqijO5xZHiWMQZXqbx6T8v1EWMgPxNDowm1mR7D0Mdq3xeXElPODgnT2KkiNn+ONT4XfVgoCag+js13gzqt/OVpm6w6UucRyzjXY5EpRStwn47CtKVnLqt3BNkty/+EjxU2y8acRRRDx91gAKLETj/Jy5ISxzNNvsr7U0V0QC7357257ddg+IDV1A0HftnmmOvkI22iFImBQskn/Q9hyrhpetqIeIrRWMheUECtgTx4lmN8OC/G1YI3TF7gKDHm+", "kRlRk6oMHIHxo+Jg4O4mICF+Ehy9Ms7B9v0+vfQUvDQ="};
        byte[][] deced = agent1.decryptWangLianEnvelope(envelope, certid);
        System.out.println(agent1.getReturnCode());
        System.out.println(new String(deced[0]));
    }

    private static void testWangLianEnvelope() {
        String certid = "5year";
        String encAlg = "AES";
        PBCAgent2G agent1 = new PBCAgent2G();
        agent1.openSignServer("10.20.89.163", "10001", "11111111");
        byte[] plain1 = "12312323foijsdfwqwqef".getBytes();
        byte[][] plain = new byte[][]{plain1};
        System.out.println(System.currentTimeMillis());
        String[] envelope = agent1.makeWangLianEnvelope(plain, certid, encAlg);
        System.out.println(System.currentTimeMillis());
        System.out.println("ret:" + agent1.getReturnCode());
        System.out.println("encedkey:" + envelope[0]);
        int i = 1;
        while (i < envelope.length) {
            System.out.println("encedmsg(" + i + "):" + envelope[i]);
            ++i;
        }
        byte[][] deced = agent1.decryptWangLianEnvelope(envelope, certid);
        System.out.println("ret:" + agent1.getReturnCode());
        int i2 = 0;
        while (i2 < deced.length) {
            System.out.println("plain(" + (i2 + 1) + "):" + new String(deced[i2]));
            if (!Arrays.equals(deced[i2], plain[i2])) {
                System.out.print("decrypt failed");
                System.exit(0);
            }
            ++i2;
        }
        agent1.closeSignServer();
    }

    private static void testRAWwithDigest() {
        String certid = "O=infosec,CN=sm2_rev";
        PBCAgent2G agent1 = new PBCAgent2G();
        agent1.openSignServer("10.20.89.240", "10001", "11111111");
        String signed = agent1.rawSign("1".getBytes(), certid, "SM3");
        System.out.println("ret:" + agent1.getReturnCode());
        System.out.println(signed);
        boolean verified = agent1.rawVerify("1".getBytes(), signed, certid, "SHA1");
        System.out.println(verified);
        agent1.closeSignServer();
    }

    private static void testRAWVerify() {
        PBCAgent2G agent1 = new PBCAgent2G();
        agent1.openSignServer("192.168.2.248", "40019", "123");
        boolean ret = agent1.rawVerify("1".getBytes(), "MEQCIIZYPHBfJ6BebSLoeCV7mnXdw2Uzzy9ivFu6mRLwuQ3SAiB+X25gtBxxG8BucdLsgqHhgpkbghGqMdhrN8hOcEPXtQ==", "shaoyn3");
        System.out.println(agent1.getReturnCode());
        agent1.closeSignServer();
    }

    private static void testDetachedVerify() throws Exception {
        PBCAgent2G agent1 = new PBCAgent2G();
        agent1.openSignServer("192.168.2.248", "40019", "123");
        boolean length = false;
        Object signed = null;
        FileInputStream in = new FileInputStream("D:\\TEMP\\pbc\\CIPS\\Detached.txt");
        byte[] bs = new byte[in.available()];
        in.read(bs);
        System.out.println(new String(bs));
        GenericCertificate gcert = agent1.dettachedVerify("1".getBytes(), new String(bs));
        System.out.println(agent1.getReturnCode());
        agent1.closeSignServer();
    }

    private static void testDetachedSign() throws Exception {
        PBCAgent2G agent1 = new PBCAgent2G();
        agent1.openSignServer("192.168.2.248", "40019", "123");
        int length = 0;
        String signed = null;
        signed = agent1.unstandardDettachedSign("1".getBytes(), "C=cn,O=infosec,CN=shaoyn3", "PBCSHLC");
        if (length == 0) {
            length = signed.length();
        }
        if (length != signed.length()) {
            System.out.println(signed);
        }
        agent1.unstandardDettachedVerify("1".getBytes(), signed, "PBCSHLC");
        System.out.println(agent1.getReturnCode());
        FileOutputStream out = new FileOutputStream("D:\\TEMP\\pbc\\CIPS\\1.p7b");
        out.write(signed.getBytes());
        out.flush();
        out.close();
        agent1.closeSignServer();
    }

    private static void testRAW() {
        PBCAgent2G agent1 = new PBCAgent2G();
        agent1.openSignServer("10.20.88.251", "10001", "11111111");
        boolean length = false;
        String signed = null;
        signed = agent1.rawSign("1".getBytes(), "CN=20171124_SM2\uff08\u4fe1\u5b89\u4e16\u7eaa\uff09,C=CN");
        System.out.println(signed);
    }

    private static void testUnstandardDetached() {
        PBCAgent2G agent1 = new PBCAgent2G();
        agent1.openSignServer("192.168.3.248", "8446", "123");
        String signed = agent1.unstandardDettachedSign("1".getBytes(), null, "PBCSHLC");
        System.out.println(agent1.getReturnCode());
        agent1.unstandardDettachedVerify("1".getBytes(), signed, "PBCSHLC");
        System.out.println(agent1.getReturnCode());
        agent1.closeSignServer();
    }

    private static void test2() {
        PBCAgent2G agent1 = new PBCAgent2G();
        PBCAgent2G.setIsAutoTestServices(false);
        PBCAgent2G.setServiceTestInterval(3000L);
        PBCAgent2G.setConnectionMode(1);
        agent1.openSignServer("192.168.2.248,192.168.2.248", "40019,5555", "11111111,11111111");
        String signed = agent1.rawSign("11111111".getBytes(), "C=CN,O=CFCA SM2 TEST OCA21,OU=CMBC,CN=041@ZtestSM273101@testSM273101@00000001");
        System.out.println(signed);
        agent1.rawVerify("1111111".getBytes(), signed, "testSM273101");
        System.out.println(agent1.getReturnCode());
    }

    private static void test1() {
        NetSignAgentRes.setTestInterval(3000L);
        NetSignAgentRes.setConnectionMode(2);
        PBCAgent2G agent1 = new PBCAgent2G();
        agent1.openSignServer("192.168.2.248,192.168.2.248", "40019,5555", " , ");
        PBCAgent2G agent2 = new PBCAgent2G();
        agent2.openSignServer("192.168.2.248,192.168.2.248", "40019,5555", " , ");
        while (true) {
            String signed = agent1.dettachedSign("123".getBytes(), "CN=5year,O=syn080924,C=cn");
            System.out.println(agent1.getReturnCode());
            System.out.println(signed);
            signed = agent2.dettachedSign("123".getBytes(), "CN=5year,O=syn080924,C=cn");
            System.out.println(agent1.getReturnCode());
            System.out.println(signed);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
            }
        }
    }
}

