/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.agent.SecurityRandom;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.FileInputStream;
import java.security.cert.X509Certificate;
import java.util.PropertyResourceBundle;

public class TestGenRandom {
    private static X509Certificate cert = null;

    public static void main(String[] args) {
        try {
            FileInputStream in = new FileInputStream("D:\\WORK\\myjava\\infosec\\netsign\\PBC2_COM_NetSign\\netsignagent.properties");
            PropertyResourceBundle res = new PropertyResourceBundle(in);
            NetSignAgent.initialize(res);
            String certb64 = "MIIDAzCCAeugAwIBAgIES5IBODANBgkqhkiG9w0BAQUFADA2MQswCQYDVQQGEwJjbjESMBAGA1UEChMJc3luMDgwOTI0MRMwEQYDVQQDEwpyb290MDgwOTI0MB4XDTA4MTEwNzA4NDMyMVoXDTE3MTEwNzA4NDMyMVowMTEOMAwGA1UEAwwFNXllYXIxEjAQBgNVBAoMCXN5bjA4MDkyNDELMAkGA1UEBhMCY24wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAPFcLIYgYbuz18NEMcn7hopBOcUWQt0mmfjyWWJPCr5C5UltMfyXO2yPJb1EnAbfCDe72vQpl++DpvJwMlPCwnkoQGYs/SEtZYyYiiIhGOh5YRTCN0HJJlkwBkp2HE6EXTcdbUCA+ppwDsqsv+VUr63fKF45U+qOtempmT/u/uX1AgMBAAGjgaEwgZ4wEQYJYIZIAYb4QgEBBAQDAgWgMAkGA1UdEwQCMAAwUgYDVR0fBEswSTBHoEWgQ6RBMD8xDjAMBgNVBAMMBWNybDE2MQwwCgYDVQQLDANjcmwxEjAQBgNVBAoMCXN5bjA4MDkyNDELMAkGA1UEBhMCY24wCwYDVR0PBAQDAgbAMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDBDANBgkqhkiG9w0BAQUFAAOCAQEAnSkwt7bs/8GvdmGSmX8N6D+t8fO33OJVDtynhZr03kySffhwCLd221lDf4lauLyeut8wigqWmPEBGtQ8xRn+RqlTnDpRFBlAqD6TbeKjdrZ5ZvTH2fEXes7duZTAHu7I7yPqoc9wMK2il3sai30NntusE1aUDy92V4qM1BQSB1PDYGMJ8Hz1N2OU7uMKSP0KiOs6jwzbKxp3jjqPgFfR8W05UVnzISp6XbqRFCArf0a8ErvQGy41eom0bN/2itQBqe4GyvhFnFkzQ9L8Lru+atzzfFTKCO90WwOFZICvJMAZakrqgQrvMdCLUcB7glVN4TfyLYoOt1s0bGNLSk6F+w==";
            cert = NetSignAgent.generateCertificate(certb64.getBytes());
            TestGenRandom.test1();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void test1() throws Exception {
        System.out.println("-----------------gen random----------------------");
        SecurityRandom srans = new SecurityRandom();
        String certdn = "CN=5year,O=syn080924,C=cn";
        NetSignAgent.generateRandom(32, null, cert, null, true, cert.getPublicKey(), srans);
        if (srans.getRandom() != null) {
            byte[] ran = srans.getRandom();
            ConsoleLogger.logBinary("rans", ran);
        }
        System.out.println("env:" + srans.getRandomEnvelopeB64());
        System.out.println("cipher:" + srans.getRandomCipherB64());
        System.out.println("-----------------decrypt env----------------------");
        NetSignResult ret = NetSignAgent.decryptEnvelope(srans.getRandomEnvelopeB64(), null);
        System.out.println(new String(ret.getByteArrayResult("Byte_Array_Plain_Text")));
        System.out.println("-----------------rewarp env----------------------");
        ret = NetSignAgent.rewarpEnvelope(srans.getRandomEnvelope(), certdn, null, null, null);
        System.out.println(ret.getStringResult("Base64_Enveloped_Text"));
    }
}

