/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.agent.exception.ServerProcessException;
import java.io.FileInputStream;
import java.util.PropertyResourceBundle;

public class TestDetach {
    public static void main(String[] args) throws Exception {
        FileInputStream in = new FileInputStream("netsignagent.properties");
        PropertyResourceBundle prb = new PropertyResourceBundle(in);
        NetSignAgent.initialize(prb);
        TestDetach.testDetachedSign();
    }

    private static void testDetachedAfterwardsVerify() throws Exception {
        NetSignResult result = NetSignAgent.detachedSignature("111".getBytes(), null, "SHA256SM3", false);
        String signed = result.getStringResult("Base64_Signed_Text");
        result = NetSignAgent.detachedAfterwardsVerify("111".getBytes(), signed, false);
        System.out.println(result.getStringResult("DIGEST_ALG"));
    }

    private static void testDetachedSign() throws Exception {
        NetSignResult result = NetSignAgent.detachedSignature("111".getBytes(), null, "SHA256SM3", false);
        String signed = result.getStringResult("Base64_Signed_Text");
        result = NetSignAgent.detachedVerify("111".getBytes(), signed, null, false);
        System.out.println(result.getStringResult("DIGEST_ALG"));
    }

    private static void testUnstandardSign() throws Exception {
        String signed = null;
        NetSignResult result = null;
        signed = "MIICaAYKKoEcz1UGAQQCAqCCAlgwggJUAgEBMQ4wDAYIKoEcz1UBgxEFADAMBgoqgRzPVQYBBAIBoIIBkDCCAYwwggEwoAMCAQICBRAAABFWMAwGCCqBHM9VAYN1BQAwJzELMAkGA1UEBhMCQ04xGDAWBgNVBAoMD0NGQ0Egc20yIFJDQTExMTAeFw0xMzAyMjYwMjU5MjFaFw0xNDAyMjEwMjU5MjFaMB8xCzAJBgNVBAYTAkNOMRAwDgYDVQQDDAdzbTJ0ZXN0MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE7VVu9jkN1i0oUDtp0ocl8pXKF0eHXtKewa8wzmR9Ym98j67PDOhxq8YUr9VuRw+CDaJmmXZuHuf+VYjSx3qIwqNPME0wHwYDVR0jBBgwFoAUAJAK6++jihENFsJYJe0OJ5DtGCcwCwYDVR0PBAQDAgbAMB0GA1UdDgQWBBRbEMk1WzZ9V7LCM/Ae/LJEvkDMizAMBggqgRzPVQGDdQUAA0gAMEUCIHqrOB1qmaYKJPUz6j5dyxcHlyjlyqM49ixHiJQ/m/TXAiEA1+o0P25BzTa7rygPOVFXU7CKspXQHW8tyQyc/+2rsoAxgZwwgZkCAQEwMDAnMQswCQYDVQQGEwJDTjEYMBYGA1UECgwPQ0ZDQSBzbTIgUkNBMTExAgUQAAARVjAMBggqgRzPVQGDEQUAMAwGCCqBHM9VAYN1BQAwRgIhAJdtI9zvURu8XmIU9mmD6vguOg6H27d+iqwy1xafJ1GuAiEA3aeMC6gdLX1jsZrCtb81cjWSVNf+oYqlCQIh7hVx+Dg=";
        result = NetSignAgent.unstandardDetachedVerify("cfca1234".getBytes(), signed, null, false, "PBCSHLC");
        System.out.println(result.getStringResult("Sign_Subject"));
    }

    private static void testVerify() throws Exception {
        try {
            NetSignAgent.detachedVerify("2015100900096294|2015-09-10T09:27:08|cips.903.001.01|DELE|MSBCCNBJXXX|".getBytes(), "MIIDxAYKKoEcz1UGAQQCAqCCA7QwggOwAgEBMQ4wDAYIKoEcz1UBgxEFADAMBgoqgRzPVQYBBAIBoIICuDCCArQwggJZoAMCAQICBRABQxBzMAwGCCqBHM9VAYN1BQAwXDELMAkGA1UEBhMCQ04xMDAuBgNVBAoMJ0NoaW5hIEZpbmFuY2lhbCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTEbMBkGA1UEAwwSQ0ZDQSBURVNUIFNNMiBPQ0ExMB4XDTE1MDgyMTA3NDIyN1oXDTE3MDgyMTA3NDIyN1oweTELMAkGA1UEBhMCY24xFTATBgNVBAoMDENGQ0EgVEVTVCBDQTENMAsGA1UECwwEQ0lQUzEUMBIGA1UECwwLRW50ZXJwcmlzZXMxLjAsBgNVBAMMJTA0MUAzTVNCQ0NOQkpYWFhATVNCQ0NOQkpYWFhAMDAwMDAwMDMwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAAS/rnU3nW3lwKoDGT131Xy3ERHp2R9b5e2U8rW5VEJ1sREFcUCXtCutTR2KJBLUPMfJgLXEtKBpeG2EFh6jIAq0o4HoMIHlMB8GA1UdIwQYMBaAFGv+GNqPQjqmuG2zLoiDOjSiwTDhMEgGA1UdIARBMD8wPQYIYIEchu8qAQEwMTAvBggrBgEFBQcCARYjaHR0cDovL3d3dy5jZmNhLmNvbS5jbi91cy91cy0xNC5odG0wNwYDVR0fBDAwLjAsoCqgKIYmaHR0cDovL3VjcmwuY2ZjYS5jb20uY24vU00yL2NybDg5OC5jcmwwCwYDVR0PBAQDAgPoMB0GA1UdDgQWBBRbg3unyS9UNFWiPGs7WVrbyg7LFzATBgNVHSUEDDAKBggrBgEFBQcDAjAMBggqgRzPVQGDdQUAA0cAMEQCICZXucQh7y9BY7NMAB8vqfEY5OEwtmXvfa+wQwbIwhbHAiBusZ3JnyB767vS5W4rGIA7JMk18yxH8RfmQdk0d5E94jGB0DCBzQIBATBlMFwxCzAJBgNVBAYTAkNOMTAwLgYDVQQKDCdDaGluYSBGaW5hbmNpYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxGzAZBgNVBAMMEkNGQ0EgVEVTVCBTTTIgT0NBMQIFEAFDEHMwDAYIKoEcz1UBgxEFADAKBggqgRzPVQGDdQRHMEUCIQDROWjLWMALpdlr5hRlzMpQtG/TrdPc/tWTw+v2UKkqygIgOz8SVH71xiEB/v/lm5yFWiBFjtpusLuvzOV40WdYrwU=", null, true);
            System.out.println("verify success");
        }
        catch (ServerProcessException e) {
            System.out.println(e.getErrorCode());
        }
    }
}

