/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.oscca;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1Object;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.jce.oscca.SM3;
import cn.com.infosec.math.ec.ECConstants;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.ec.ECFieldElement;
import cn.com.infosec.math.ec.ECPoint;
import cn.com.infosec.util.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;

public class SM2Util {
    public static final int SM2_SIZE = 32;
    public static final BigInteger gmp = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    public static final BigInteger gma = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    public static final BigInteger gmb = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    public static final ECCurve gmec256 = new ECCurve.Fp(gmp, gma, gmb);
    public static final BigInteger gmgx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    public static final BigInteger gmgy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    public static final ECPoint gmg = gmec256.createPoint(gmgx, gmgy, false);
    public static final BigInteger gmn = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    static ECFieldElement ONE = new ECFieldElement.Fp(gmp, ECConstants.ONE);
    static ECFieldElement TWO = new ECFieldElement.Fp(gmp, ECConstants.TWO);
    static ECFieldElement FOUR = new ECFieldElement.Fp(gmp, BigInteger.valueOf(4L));
    static ECFieldElement THREE = new ECFieldElement.Fp(gmp, BigInteger.valueOf(3L));
    static ECFieldElement EIGHT = new ECFieldElement.Fp(gmp, BigInteger.valueOf(8L));
    static ECFieldElement A = new ECFieldElement.Fp(gmp, gma);

    public static byte[] getZA(byte[] id, byte[] pubkey) {
        byte[] msg = new byte[2 + id.length + 192];
        int pos = 0;
        System.arraycopy(SM2Util.getENTLa(id), 0, msg, pos, 2);
        System.arraycopy(id, 0, msg, pos += 2, id.length);
        System.arraycopy(gma.toByteArray(), 0, msg, pos += id.length, 32);
        System.arraycopy(gmb.toByteArray(), 0, msg, pos += 32, 32);
        System.arraycopy(gmgx.toByteArray(), 0, msg, pos += 32, 32);
        System.arraycopy(gmgy.toByteArray(), 0, msg, pos += 32, 32);
        pos += 32;
        if (pubkey.length == 64) {
            System.arraycopy(pubkey, 0, msg, pos, pubkey.length);
        } else if (pubkey.length == 65) {
            System.arraycopy(pubkey, 1, msg, pos, 64);
        } else if (pubkey.length == 33) {
            System.arraycopy(pubkey, 1, msg, pos, 32);
            byte yb = pubkey[0];
            pubkey[0] = 0;
            System.arraycopy(BigIntegers.asUnsignedByteArray(SM2Util.getY(new BigInteger(1, pubkey), yb)), 0, msg, pos += 32, 32);
        }
        return SM3.SM3Digest(msg);
    }

    private static BigInteger getBeta(BigInteger x) {
        BigInteger beta = null;
        BigInteger alpha = x.modPow(new BigInteger("3"), gmp).add(gma.multiply(x)).add(gmb).mod(gmp);
        BigInteger[] rs = gmp.divideAndRemainder(new BigInteger("8"));
        int reminder = rs[1].intValue();
        block0 : switch (reminder) {
            case 1: {
                break;
            }
            case 5: {
                int z = alpha.modPow(rs[0].add(rs[0]).add(BigInteger.ONE), gmp).intValue();
                switch (z) {
                    case 1: {
                        beta = alpha.modPow(rs[0].add(BigInteger.ONE), gmp);
                        break block0;
                    }
                    case -1: {
                        beta = alpha.add(alpha);
                        beta = beta.multiply(beta.add(beta).modPow(rs[0], gmp));
                        break block0;
                    }
                }
                return null;
            }
            case 6: 
            case 7: {
                beta = alpha.modPow(rs[0].add(rs[0]).add(BigInteger.ONE), gmp);
                if (beta.multiply(beta).mod(gmp).compareTo(alpha) == 0) break;
                return null;
            }
        }
        return beta;
    }

    static BigInteger getY(BigInteger x, int ypb) {
        BigInteger y = SM2Util.getBeta(x);
        if (y == null) {
            return null;
        }
        byte[] yb = BigIntegers.asUnsignedByteArray(y);
        if ((yb[yb.length - 1] & 0xFF) == ypb - 2) {
            return y;
        }
        return gmp.add(y.negate());
    }

    public static byte[] point2octect(ECPoint p) {
        byte[] pb = new byte[65];
        pb[0] = 4;
        byte[] tmpib = new byte[32];
        tmpib = BigIntegers.asUnsignedByteArray(p.getX().toBigInteger());
        if (tmpib.length > 32) {
            return null;
        }
        System.arraycopy(tmpib, 0, pb, 33 - tmpib.length, tmpib.length);
        tmpib = BigIntegers.asUnsignedByteArray(p.getY().toBigInteger());
        if (tmpib.length > 32) {
            return null;
        }
        System.arraycopy(tmpib, 0, pb, 65 - tmpib.length, tmpib.length);
        return pb;
    }

    public static void point2octect(ECPoint p, byte[] x, byte[] y) {
        System.arraycopy(BigIntegers.asUnsignedByteArray(p.getX().toBigInteger()), 0, x, 0, 32);
        System.arraycopy(BigIntegers.asUnsignedByteArray(p.getY().toBigInteger()), 0, y, 0, 32);
    }

    public static ECPoint octect2point(byte[] pb) {
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        switch (pb.length) {
            case 33: {
                int px = 1;
                System.arraycopy(pb, px, x, 0, 32);
                BigInteger kx = new BigInteger(1, x);
                BigInteger ky = SM2Util.getY(kx, pb[0]);
                if (ky == null) {
                    return null;
                }
                return gmec256.createPoint(kx, ky, false);
            }
            case 65: {
                int px = 1;
                int py = 33;
                if (pb[0] != 4) {
                    return null;
                }
                System.arraycopy(pb, px, x, 0, 32);
                System.arraycopy(pb, py, y, 0, 32);
                break;
            }
            case 64: {
                int px = 0;
                int py = 32;
                System.arraycopy(pb, px, x, 0, 32);
                System.arraycopy(pb, py, y, 0, 32);
                break;
            }
            default: {
                return null;
            }
        }
        return gmec256.createPoint(new BigInteger(1, x), new BigInteger(1, y), false);
    }

    static byte[] getENTLa(byte[] id) {
        byte[] la = new byte[2];
        int entlena = id.length * 8;
        la[1] = (byte)(entlena & 0xFF);
        la[0] = (byte)(entlena >> 8 & 0xFF);
        return la;
    }

    public static byte[] derEncode(BigInteger r, BigInteger s) {
        try {
            ASN1Encodable[] rs = new DERInteger[]{new DERInteger(r), new DERInteger(s)};
            return new DERSequence(rs).getEncoded("DER");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BigInteger[] derDecode(byte[] encoding) {
        try {
            ASN1Sequence s = (ASN1Sequence)ASN1Object.fromByteArray(encoding);
            return new BigInteger[]{((DERInteger)s.getObjectAt(0)).getValue(), ((DERInteger)s.getObjectAt(1)).getValue()};
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] I2OSP(int x) {
        byte[] result = new byte[]{(byte)(x >>> 24), (byte)(x >>> 16), (byte)(x >>> 8), (byte)x};
        return result;
    }
}

