/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.logger;

import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class ConsoleLogger {
    private static Date now;
    private static SimpleDateFormat format;
    public static boolean isPrintST;
    public static boolean isDebug;
    public static boolean isSave;
    private static int projectID;
    private static final String title = "ISFJ";

    static {
        isPrintST = true;
        isDebug = false;
        isSave = false;
        projectID = 0;
        now = new Date();
        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    private static void printHead() {
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("---------------").append(title).append("(").append(time).append(")---------------");
        System.out.println(sbuilder);
    }

    private static void printTail() {
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("--------------------------------------------------").append("----");
        System.out.println(sbuilder);
    }

    public static void logException(Throwable e, String info) {
        ConsoleLogger.printHead();
        System.out.println(info);
        System.out.println("An exception catched: " + e.toString());
        if (isPrintST) {
            System.out.println("Full stacktrace as below:");
            e.printStackTrace(System.out);
            System.out.flush();
        }
        ConsoleLogger.printTail();
    }

    public static void logException(Throwable e) {
        ConsoleLogger.printHead();
        System.out.println("An Exception catched:" + e.toString());
        if (isPrintST) {
            System.out.println("Full stacktrace as below:");
            e.printStackTrace(System.out);
            System.out.flush();
        }
        ConsoleLogger.printTail();
    }

    public static void logBinary(String title, byte[] bs) {
        if (!isDebug) {
            return;
        }
        ConsoleLogger.printHead();
        if (bs != null) {
            System.out.println(String.valueOf(title) + "(" + bs.length + "):");
            int i = 0;
            int length = bs.length;
            while (i < length) {
                int x = bs[i] & 0xFF;
                if (x < 16) {
                    System.out.print("0" + Integer.toString(x, 16) + " ");
                } else {
                    System.out.print(String.valueOf(Integer.toString(x, 16)) + " ");
                }
                if ((i + 1) % 32 == 0) {
                    System.out.print("\n");
                }
                ++i;
            }
            System.out.print("\n");
        } else {
            System.out.println(String.valueOf(title) + "(0):");
        }
        ConsoleLogger.printTail();
    }

    public static void saveBinary(String file, byte[] bs) {
        if (isSave) {
            block15: {
                ConsoleLogger.printHead();
                System.out.println("Binary stream saved to file:" + file);
                FileOutputStream out = null;
                try {
                    try {
                        out = new FileOutputStream(file);
                        out.write(bs);
                        out.flush();
                    }
                    catch (Exception e) {
                        ConsoleLogger.logException(e);
                        try {
                            if (out != null) {
                                out.close();
                            }
                            break block15;
                        }
                        catch (Exception exception) {}
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ConsoleLogger.printTail();
        }
    }

    public static void saveReaded(String file, byte[] content, byte[] length, byte flag) {
        if (isSave) {
            block15: {
                ConsoleLogger.printHead();
                System.out.println("Binary readed stream saved to file:" + file);
                FileOutputStream out = null;
                try {
                    try {
                        out = new FileOutputStream(file);
                        byte[] tmp = new byte[1 + length.length];
                        tmp[0] = flag;
                        System.arraycopy(length, 0, tmp, 1, length.length);
                        out.write(tmp);
                        out.write(content);
                        out.flush();
                    }
                    catch (Exception e) {
                        ConsoleLogger.logException(e);
                        try {
                            if (out != null) {
                                out.close();
                            }
                            break block15;
                        }
                        catch (Exception exception) {}
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ConsoleLogger.printTail();
        }
    }

    public static void logStringForce(String msg) {
        ConsoleLogger.printHead();
        System.out.println(msg);
        ConsoleLogger.printTail();
    }

    public static void logString(byte[] msg) {
        if (!isDebug) {
            return;
        }
        ConsoleLogger.printHead();
        System.out.println(new String(msg));
        ConsoleLogger.printTail();
    }

    public static void logString(String msg) {
        if (!isDebug) {
            return;
        }
        ConsoleLogger.printHead();
        System.out.println(msg);
        ConsoleLogger.printTail();
    }

    public static void logString(String msg, int pid) {
        if (!isDebug) {
            return;
        }
        if (pid == projectID || projectID < 0) {
            ConsoleLogger.printHead();
            System.out.println(msg);
            ConsoleLogger.printTail();
        }
    }

    public static void logArray(Object[] objs) {
        if (!isDebug) {
            return;
        }
        ConsoleLogger.printHead();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int i = 0;
        int length = objs.length;
        while (i < length) {
            buf.append(" \"").append(objs[i].toString()).append("\"");
            ++i;
        }
        buf.append("]");
        System.out.println(buf.toString());
        ConsoleLogger.printTail();
    }

    public static void logMap(Map m) {
        if (!isDebug) {
            return;
        }
        ConsoleLogger.printHead();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (Object key : m.keySet()) {
            buf.append(" \"").append(key.toString()).append("=").append(m.get(key).toString()).append("\"");
        }
        buf.append("]");
        System.out.println(buf.toString());
        ConsoleLogger.printTail();
    }
}

