/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.digests;

import cn.com.infosec.crypto.digests.GeneralDigest;

public class SM3Digest
extends GeneralDigest {
    public static final int DIGEST_LENGTH = 32;
    private int[] H = new int[8];
    private final byte[] msg = new byte[64];
    private final boolean debug = false;
    private int currentPos;
    private long currentLen;

    public SM3Digest() {
        this.reset();
    }

    public SM3Digest(SM3Digest t) {
        super(t);
        System.arraycopy(t.H, 0, this.H, 0, 8);
        System.arraycopy(t.msg, 0, this.msg, 0, 64);
        this.currentLen = t.currentLen;
        this.currentPos = t.currentPos;
    }

    public String getAlgorithmName() {
        return "SM3";
    }

    public int getDigestSize() {
        return 32;
    }

    public void reset() {
        super.reset();
        this.H[7] = 1937774191;
        this.H[6] = 1226093241;
        this.H[5] = 388252375;
        this.H[4] = -628488704;
        this.H[3] = -1452330820;
        this.H[2] = 372324522;
        this.H[1] = -477237683;
        this.H[0] = -1325724082;
        int i = 0;
        while (i < this.msg.length) {
            this.msg[i] = 0;
            ++i;
        }
        this.currentPos = 0;
        this.currentLen = 0L;
    }

    public void update(byte[] b, int off, int len) {
        int i = off;
        while (i < off + len) {
            this.update(b[i]);
            ++i;
        }
    }

    public void update(byte[] b) {
        int i = 0;
        while (i < b.length) {
            this.update(b[i]);
            ++i;
        }
    }

    public void update(byte b) {
        this.msg[this.currentPos++] = b;
        this.currentLen += 8L;
        if (this.currentPos == 64) {
            this.processBlock();
            this.currentPos = 0;
        }
    }

    public final void processWord(byte[] in, int inOff) {
        this.msg[this.currentPos++] = in[inOff];
        this.currentLen += 8L;
        if (this.currentPos == 64) {
            this.processBlock();
            this.currentPos = 0;
        }
    }

    private final void putInt(byte[] b, int pos, int val) {
        b[pos] = (byte)(val >> 24);
        b[pos + 1] = (byte)(val >> 16);
        b[pos + 2] = (byte)(val >> 8);
        b[pos + 3] = (byte)val;
    }

    public int doFinal(byte[] out, int off) {
        long l = this.currentLen;
        this.update((byte)-128);
        while (this.currentPos != 56) {
            this.update((byte)0);
        }
        this.update((byte)(l >> 56));
        this.update((byte)(l >> 48));
        this.update((byte)(l >> 40));
        this.update((byte)(l >> 32));
        this.update((byte)(l >> 24));
        this.update((byte)(l >> 16));
        this.update((byte)(l >> 8));
        this.update((byte)l);
        this.putInt(out, off, this.H[7]);
        this.putInt(out, off + 4, this.H[6]);
        this.putInt(out, off + 8, this.H[5]);
        this.putInt(out, off + 12, this.H[4]);
        this.putInt(out, off + 16, this.H[3]);
        this.putInt(out, off + 20, this.H[2]);
        this.putInt(out, off + 24, this.H[1]);
        this.putInt(out, off + 28, this.H[0]);
        this.reset();
        return 32;
    }

    protected void processBlock() {
        int[] w = new int[68];
        int[] wd = new int[64];
        int[] vj = new int[8];
        int j = 0;
        while (j < 16) {
            w[j] = (this.msg[j * 4] & 0xFF) << 24 | (this.msg[j * 4 + 1] & 0xFF) << 16 | (this.msg[j * 4 + 2] & 0xFF) << 8 | this.msg[j * 4 + 3] & 0xFF;
            ++j;
        }
        j = 16;
        while (j < 68) {
            w[j] = this.p1(w[j - 16] ^ w[j - 9] ^ this.rotl(w[j - 3], 15)) ^ this.rotl(w[j - 13], 7) ^ w[j - 6];
            ++j;
        }
        j = 0;
        while (j < 64) {
            wd[j] = w[j] ^ w[j + 4];
            ++j;
        }
        int i = 0;
        while (i < 8) {
            vj[i] = this.H[i];
            ++i;
        }
        int T0_15 = 2043430169;
        int T16_63 = 2055708042;
        int j2 = 0;
        while (j2 < 64) {
            int ss1 = j2 < 16 ? this.rotl(this.rotl(vj[7], 12) + vj[3] + this.rotl(2043430169, j2), 7) : this.rotl(this.rotl(vj[7], 12) + vj[3] + this.rotl(2055708042, j2), 7);
            int ss2 = ss1 ^ this.rotl(vj[7], 12);
            int tt1 = j2 < 16 ? this.FF_0_15(vj[7], vj[6], vj[5]) + vj[4] + ss2 + wd[j2] : this.FF_16_63(vj[7], vj[6], vj[5]) + vj[4] + ss2 + wd[j2];
            int tt2 = j2 < 16 ? this.GG_0_15(vj[3], vj[2], vj[1]) + vj[0] + ss1 + w[j2] : this.GG_16_63(vj[3], vj[2], vj[1]) + vj[0] + ss1 + w[j2];
            vj[4] = vj[5];
            vj[5] = this.rotl(vj[6], 9);
            vj[6] = vj[7];
            vj[7] = tt1;
            vj[0] = vj[1];
            vj[1] = this.rotl(vj[2], 19);
            vj[2] = vj[3];
            vj[3] = this.p0(tt2);
            ++j2;
        }
        int i2 = 0;
        while (i2 < 8) {
            int n = i2;
            this.H[n] = this.H[n] ^ vj[i2];
            ++i2;
        }
    }

    private final int FF_0_15(int a, int b, int c) {
        return a ^ b ^ c;
    }

    private final int FF_16_63(int a, int b, int c) {
        return a & b | a & c | b & c;
    }

    private final int GG_0_15(int a, int b, int c) {
        return this.FF_0_15(a, b, c);
    }

    private final int GG_16_63(int a, int b, int c) {
        return a & b | ~a & c;
    }

    private final int rotl(int value, int bits) {
        return value << bits | value >>> -bits;
    }

    private final int p0(int x) {
        return x ^ this.rotl(x, 9) ^ this.rotl(x, 17);
    }

    private final int p1(int x) {
        return x ^ this.rotl(x, 15) ^ this.rotl(x, 23);
    }

    public static void main(String[] args) {
    }

    protected void processLength(long bitLength) {
    }
}

