package com.clx.performance.vo.feign;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;


@Getter
@Setter
@NoArgsConstructor
public class OrderGoodsFeignVO {

    @Schema(description="订单编号")
    private String orderNo;

    @Schema(description="货单编号")
    private String orderGoodsNo;

    @Schema(description="货单状态")
    private Integer orderGoodsStatus;

    @Schema(description="提取吨数")
    private BigDecimal extractWeight;

    @Schema(description="剩余拉运吨数")
    private BigDecimal residueTransportWeight;

    @Schema(description="已拉运吨数")
    private BigDecimal alreadyTransportWeight;

    @Schema(description="发货地址ID")
    private Integer sendAddressId;

    @Schema(description = "发货地址全称")
    private String sendAddressAll;

    @Schema(description="发货地址简称")
    private String sendAddressShorter;

    @Schema(description="发货地址经度")
    private BigDecimal sendLongitude;

    @Schema(description="发货地址纬度")
    private BigDecimal sendLatitude;

    @Schema(description="收货地址ID")
    private Integer receiveAddressId;

    @Schema(description="收货地址全称")
    private String reveiveAddressAll;

    @Schema(description="收货地址简称")
    private String receiveAddressShorter;

    @Schema(description="收货地址经度")
    private BigDecimal receiveLongitude;

    @Schema(description="收货地址纬度")
    private BigDecimal receiveLatitude;

    @Schema(description="货物ID")
    private Integer goodsId;

    @Schema(description="货物名称")
    private String goodsName;

    @Schema(description="挂单方式  1公开派单  2定向派单")
    private Integer pendingOrderWay;

    @Schema(description="定向运单失效时间")
    private String directionalExpireTime;

    @Schema(description="最晚到达货源地时间/运单的最晚装货时间")
    private String lastArriveSendTime;

    @Schema(description="挂单时间")
    private String pendingOrderTime;

    @Schema(description="提取方式 1提取全部 2提取部分")
    private Integer extractWay;

    @Schema(description="需要车辆/辆")
    private Integer needTruckNum;

    @Schema(description="高级物流经理id")
    private Integer seniorLogisticsManagerId;

    @Schema(description="高级物流经理姓名")
    private String seniorLogisticsManagerName;

    @Schema(description="挂单运费")
    @MoneyOutConvert
    private BigDecimal pendingOrderFreight;

    @Schema(description="创建人用户编号")
    private Long userNo;

    @Schema(description="创建人姓名")
    private String userName;

    @Schema(description="创建时间")
    private String createTime;


}