package com.clx.performance.vo.app;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class APPNetworkDriverRunningWaterRecordVO {

    private Integer id;

    @Schema(description="流水号")
    private Long runningWaterNo;

    @Schema(description="司机编码")
    private Long driverUserNo;

    @Schema(description="司机名称")
    private String driverUserName;

    @Schema(description="联系电话")
    private String mobile;

    @Schema(description="流水类型 10：运单结算 20：提现冻结 30：提现成功")
    private Integer runningWaterType;

    @Schema(description="流水类型简介")
    private String runningWaterTypeMsg;

    @Schema(description="资金类型 10：收入 20：冻结 30：支出")
    private Integer fundType;

    @Schema(description="资金类型简介")
    private String fundTypeMsg;

    @Schema(description="")
    private Long relationId;

    @Schema(description="货单编号")
    private String orderGoodsNo;

    @Schema(description="订单编号")
    private String orderNo;

    @Schema(description="运单编号")
    private String childNo;

    @Schema(description="变动金额")
    @MoneyOutConvert
    private BigDecimal alterationBalance;

    @Schema(description="冻结金额")
    @MoneyOutConvert
    private BigDecimal frozenBalance;

    @Schema(description="可用余额")
    @MoneyOutConvert
    private BigDecimal usableBalance;

    @Schema(description="账户余额")
    @MoneyOutConvert
    private BigDecimal accountBalance;

    @Schema(description="扣除金额")
    @MoneyOutConvert
    private BigDecimal takeOutBalance;

    @Schema(description="操作人")
    private String createBy;

    @Schema(description="创建时间")
    private String createTime;

    @Schema(description="修改时间")
    private String modifiedTime;

}
