package com.clx.performance.param.temp;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.List;

@Setter
@Getter
@ToString
@NoArgsConstructor
public class DriverTraceAddParam {

    @Schema(description = "车辆轨迹列表")
    private List<DriverTraceItem> traceList;

    @Setter
    @Getter
    @ToString
    @NoArgsConstructor
    public static class DriverTraceItem{
        @Schema(description = "用户编码", example = "10000")
        private Long userNo;
        @Schema(description = "1-正常上传，2-离线上传", example = "1")
        private Integer dataType;
        @Schema(description = "位置 [123.45, 12.34]")
        private BigDecimal[] location;
        @Schema(description = "时间")
        private String gpsTime;
        @Schema(description = "速度", example = "12.34")
        private BigDecimal speed;
    }

}
