package com.clx.performance.param.pc.breakcontract.owner;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
@ToString
public class PageOwnerBreakContractOwnerRecordParam extends PageParam {

    @Schema(description = "货主编号", example = "1",hidden = true)
    private Long ownerUserNo;

    @Schema(description = "订单号", example = "1000000000")
    private String orderNo;

    @NotNull(message = "违约方类型不能为空")
    @Schema(description = "违约方类型：1平台 2货主 3司机", example = "1")
    private Integer breakContractPartyType;

    @Schema(description = "缴费状态：0未缴费;1已缴费/赔付状态：0未赔付;1已赔付", example = "1")
    private Integer payStatus;

    @Schema(description = "开始时间", example = "2012-01-01 00:00:00")
    private String beginTime;

    @Schema(description = "结束时间", example = "2012-01-01 00:00:00")
    private String endTime;
}
