package com.clx.performance.param.feign.transport;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Data
public class ThirdOrderChildBrokerParam {

    @Schema(description = "运单编码", required = true)
    @NotBlank(message = "订单编码不能为空")
    private String childNo;

    @Schema(description = "订单编码", required = true)
    @NotBlank(message = "货单编码不能为空")
    private String orderNo;
    @Schema(description = "车牌号", required = true)
    @NotBlank(message = "车牌号不能为空")
    private String truckNo;

    @Schema(description = "运费单价 单位分 (司机运费单价)", required = true)
    @NotNull(message = "运费单价不能为空")
    private Integer freightPrice;
    @Schema(description = "运费 单位分 (含税金额)", required = true)
    @NotNull(message = "运费不能为空")
    private Integer freight;
    @Schema(description = "实付运费 单位分 (司机运费总价)", required = true)
    @NotNull(message = "实付运费不能为空")
    private Integer freightNoCard;
    @Schema(description = "溢价金额", required = true)
    @NotNull(message = "溢价金额不能为空")
    private Integer orderChildBrokerBeyondFreight = 0;
    @Schema(description = "司机实际净重", required = true)
    @NotNull(message = "司机实际净重不能为空")
    private BigDecimal net;
    @Schema(description = "装车净重")
    @NotNull(message = "装车净重不能为空")
    private BigDecimal loadNet;

    @Schema(description = "发货地址", required = true)
    @NotBlank(message = "发货地址不能为空")
    private String sendAddress;
    @Schema(description = "货源所在省份", required = true)
    @NotBlank(message = "货源所在省份不能为空")
    private String sendProvince;
    @Schema(description = "货源所在城市", required = true)
    @NotBlank(message = "货源所在城市不能为空")
    private String sendCity;
    @Schema(description = "货源所在区县", required = true)
    @NotBlank(message = "货源所在区县不能为空")
    private String sendCounty;
    @Schema(description = "货源所在乡镇", required = true)
//    @NotBlank(message = "货源所在乡镇不能为空")
    private String sendTown;
    @Schema(description = "发货人", required = true)
    @NotBlank(message = "发货人不能为空")
    private String sendName;
    @Schema(description = "发货人手机号", required = true)
    @NotBlank(message = "发货人手机号不能为空")
    private String sendMobile;

    @Schema(description = "收货人所在省", required = true)
    @NotBlank(message = "收货人所在省不能为空")
    private String receiveProvince;
    @Schema(description = "收货人所在城市", required = true)
    @NotBlank(message = "收货人所在城市不能为空")
    private String receiveCity;
    @Schema(description = "收货人所在区县", required = true)
    @NotBlank(message = "收货人所在区县不能为空")
    private String receiveCounty;
    @Schema(description = "收货人所在乡镇", required = true)
//    @NotBlank(message = "收货人所在乡镇不能为空")
    private String receiveTown = "手动";
    @Schema(description = "收货地址", required = true)
    @NotBlank(message = "收货地址不能为空")
    private String receiveAddress;
    @Schema(description = "收货人", required = true)
    @NotBlank(message = "收货人不能为空")
    private String receiveName;
    @Schema(description = "收货人手机号", required = true)
    @NotBlank(message = "收货人手机号不能为空")
    private String receiveMobile;

    @Schema(description = "装车地址经度", required = true)
    @NotBlank(message = "装车地址经度不能为空")
    private String loadLongitude;
    @Schema(description = "装车地址纬度", required = true)
    @NotBlank(message = "装车地址纬度不能为空")
    private String loadLatitude;
    @Schema(description = "卸车地址经度", required = true)
    @NotBlank(message = "卸车地址经度不能为空")
    private String unloadLongitude;
    @Schema(description = "卸车地址纬度", required = true)
    @NotBlank(message = "卸车地址纬度不能为空")
    private String unloadLatitude;
    @Schema(description = "运输距离（公里）", required = true)
    @NotNull(message = "运输距离不能为空")
    private BigDecimal distance;

    @Schema(description = "接单时间", required = true)
    @NotBlank(message = "接单时间不能为空")
    private String payTime;
    @Schema(description = "装车时间", required = true)
    @NotBlank(message = "装车时间不能为空")
    private String loadTime;
    @Schema(description = "卸车时间", required = true)
    @NotBlank(message = "卸车时间不能为空")
    private String unloadTime;
    @Schema(description = "支付完成时间", required = true)
    @NotBlank(message = "支付完成时间不能为空")
    private String payFinishedTime;

//    @Schema(description = "备注")
//    private String remark;
    @Schema(description = "创建时间", required = true)
    private String createTime;

    @Schema(description = "收货单位")
    private String receiveCompany;
    @Schema(description = "发货单位")
    private String sendCompany;
    @Schema(description = "卸车净重", required = true)
    @NotNull(message = "卸车净重不能为空")
    private BigDecimal receiveNet;

    @Schema(description = "货物名称", required = true)
    @NotBlank(message = "货物名称不能为空")
    private String goodsName;
//    @Schema(description = "是否车主本人：1是，0否", required = true)
//    private Integer personalDriverFlag;

    @Schema(description = "垫付类型 0 全额垫付 1 不垫付服务费", required = true)
    @NotNull(message = "垫付类型不能为空")
    private Integer advanceType;

    @Schema(description = "货物价格 单位 分", required = true)
    @NotNull(message = "货物价格不能为空")
    private Integer goodsPrice;

    @Schema(description = "源订单号 (承运平台订单号)")
    @NotBlank(message = "源订单号不能为空")
    private String sourceOrderNo;
    @Schema(description = "源货单号 (承运平台货单号)")
    @NotBlank(message = "源货单号不能为空")
    private String sourceGoodsNo;

    @Schema(description = "源开票方式 (开票方式) ：1 装车 2 卸车")
    @NotNull(message = "源开票方式不能为空")
    private Integer sourceInvoicingType;
    @Schema(description = "源单价 (承运单价)")
    @NotNull(message = "源单价不能为空")
    private BigDecimal sourceFreightPrice;
    @Schema(description = "源开票金额 (开票金额)")
    @NotNull(message = "源开票金额不能为空")
    private BigDecimal sourceInvoicingPrice;
    @Schema(description = "源亏吨金额 (亏吨金额)")
    @NotNull(message = "源亏吨金额不能为空")
    private BigDecimal sourceLossPrice;

    @Schema(description = "装车磅单图片", required = true)
    @NotEmpty(message = "装车磅单图片不能为空")
    private List<String> loadPoundImages;
    @Schema(description = "卸车磅单图片", required = true)
    @NotEmpty(message = "卸车磅单图片不能为空")
    private List<String> unLoadPoundImages;

    @Schema(description = "关联账号(货主手机号)", required = true)
    @NotBlank(message = "关联账号不能为空")
    private String invoiceRelationNo;

    @Schema(description = "货单信息", required = true)
    @Valid
    private ThirdOrderInfoDTO orderInfoDTO;

    @Schema(description = "车主信息", required = true)
    @Valid
    private OrderChildDriverInfoDTO truckDriverInfoDTO;

    @Schema(description = "司机信息", required = true)
    @Valid
    private OrderChildDriverInfoDTO driverInfoDTO;

    @Schema(description = "车主银行卡信息", required = true)
    @Valid
    private OrderChildBankInfoDTO truckDriverBankInfoDTO;

    @Schema(description = "司机银行卡信息", required = true)
    @Valid
    private OrderChildBankInfoDTO driverBankInfoDTO;

    @Schema(description = "车辆信息", required = true)
    @Valid
    private OrderChildTruckInfoDTO truckInfoDTO;

    @Schema(description = "运单轨迹", required = true)
    @Valid
    @NotEmpty(message = "运单轨迹不能为空")
    private List<OrderChildTruckTraceDTO> brokerTraceList;

//    @Schema(description = "来源:0-货易来,1-诚联信 2承运", hidden = true)
//    private Integer source;

}
