package com.clx.performance.enums.settle;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;


public enum SettlementDriverDetailEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum PayAcceptStatus {
        INIT(0, "未受理支付"),
        ACCEPTING(1, "支付受理中"),
        ACCEPTED(2,"已受理支付"),
        ;
        private final Integer code;
        private final String msg;

        public static Optional<PayAcceptStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(PayAcceptStatus::getMsg).orElse(null);
        }
    }
}
