package com.clx.performance.model.breakcontract;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("break_contract_settlement_driver")
public class BreakContractSettlementDriver  implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("break_contract_party_type")
    @Schema(description="违约方类型：1平台 2货主 3车主")
    private Integer breakContractPartyType;

    @TableField("break_no")
    @Schema(description="违约单号")
    private String breakNo;

    @TableField("settlement_no")
    @Schema(description="结算单编号")
    private String settlementNo;

    @TableField("truck_own_user_no")
    @Schema(description="车主用户编号")
    private Long truckOwnUserNo;

    @TableField("truck_own_name")
    @Schema(description="车主名称")
    private String truckOwnName;

    @TableField("driver_user_no")
    @Schema(description="司机用户编号")
    private Long driverUserNo;

    @TableField("driver_name")
    @Schema(description="司机名称")
    private String driverName;

    @TableField("child_no")
    @Schema(description="运单编号")
    private String childNo;

    @TableField("figure")
    @Schema(description="违约金（分）")
    private BigDecimal figure;

    @TableField("break_contract_remark")
    @Schema(description="违约说明")
    private String breakContractRemark;

    @TableField("settle_status")
    @Schema(description="结算状态 1待结算;2已结算")
    private Integer settleStatus;

    @TableField("settle_platform")
    @Schema(description="结算平台 0马上来")
    private Integer settlePlatform;

    @TableField("settle_time")
    @Schema(description="结算时间")
    private LocalDateTime settleTime;

    @TableField("pay_remark")
    @Schema(description="支付备注")
    private String payRemark;

    @TableField("create_by")
    @Schema(description="操作人编号")
    private Long createBy;

    @TableField("create_name")
    @Schema(description="操作人名称")
    private String createName;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
