package com.clx.performance.controller.pc.integral;

import com.clx.performance.param.pc.integral.IntegralRuleUpdateParam;
import com.clx.performance.service.integral.IntegralRuleService;
import com.clx.performance.vo.pc.integral.AppIntegralRuleVO;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/integral/rule")
@Validated
@Tag(name = "承运端-积分规则")
@AllArgsConstructor
public class IntegralRuleController {

    @Autowired
    private IntegralRuleService integralRuleService;

    @Operation(summary = "更新积分规则", description = "<br>By:艾庆国")
    @PostMapping("/updateRule")
    @UnitCovert
    public Result<Void> updateRule(@RequestBody @Validated IntegralRuleUpdateParam param) {
        integralRuleService.updateRule(param);

        return Result.ok();
    }

    @Operation(summary = "查询积分规则信息", description = "<br>By:艾庆国")
    @GetMapping(value = "getRuleInfo")
    @UnitCovert(param = false)
    public Result<AppIntegralRuleVO> getRuleInfo() {

        return Result.ok(integralRuleService.getRuleInfo());
    }

}
