package com.clx.performance.controller.feign;

import com.clx.performance.component.GoodsOrderTruckRecordComponent;
import com.clx.performance.model.collect.CollectTruck;
import com.clx.performance.param.app.collect.CollectTruckParam;
import com.clx.performance.service.OrderGoodsTruckBindService;
import com.clx.performance.service.collect.CollectTruckService;
import com.clx.performance.vo.app.collect.AppCollectTruckVO;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import java.util.List;

@RestController
@RequestMapping("/feign/truck")
@Validated
@Tag(name = "司机上报信息Feign")
@AllArgsConstructor
public class CollectionTruckController {

    private final CollectTruckService collectTruckService;

    @Operation(summary = "司机上报车辆信息")
    @PostMapping("/listCollectTruck")
    Result<List<AppCollectTruckVO>> listCollectTruck(@RequestBody  CollectTruckParam param){
        return Result.ok(collectTruckService.listCollectTruck(param));
    }
}
