package com.clx.performance.service.impl.loan;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.loan.OwnerLoanAccountApproveDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.enums.loan.OwnerLoanAccountApproveEnum;
import com.clx.performance.model.loan.OwnerLoanAccountApprove;
import com.clx.performance.param.pc.loan.carrier.OwnerLoanAccountApproveParam;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountApproveParam;
import com.clx.performance.service.loan.OwnerLoanAccountApproveService;
import com.clx.performance.service.loan.OwnerLoanAccountService;
import com.clx.performance.struct.loan.OwnerLoanAccountApproveStruct;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanAccountApproveVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Service
@Slf4j
@AllArgsConstructor
public class OwnerLoanAccountApproveServiceImpl  implements OwnerLoanAccountApproveService {

    private final OwnerLoanAccountApproveDao ownerLoanAccountApproveDao;

    private final OwnerLoanAccountApproveStruct ownerLoanAccountApproveStruct;

    private final OwnerLoanAccountService ownerLoanAccountService;
    @Override
    public IPage<OwnerLoanAccountApproveVO> pageOwnerLoanAccountApprove(PageOwnerLoanAccountApproveParam param) {
        IPage<OwnerLoanAccountApprove> page = ownerLoanAccountApproveDao.pageOwnerLoanAccountApprove(param);
        List<OwnerLoanAccountApproveVO> records = ownerLoanAccountApproveStruct.convertList(page.getRecords());
        IPage<OwnerLoanAccountApproveVO> returnPage = new Page<>();
        returnPage.setPages(page.getPages());
        returnPage.setTotal(page.getTotal());
        returnPage.setRecords(records);
        return returnPage;
    }

    public List<OwnerLoanAccountApproveVO> getOwnerLoanAccountApproveList() {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        List<OwnerLoanAccountApprove> list = ownerLoanAccountApproveDao.getOwnerLoanAccountApproveList(loginUserInfo.getUserNo());
        return ownerLoanAccountApproveStruct.convertList(list);
    }




    @Override
    public void openOwnerLoanAccountApprove() {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        OwnerLoanAccountApprove entity = new OwnerLoanAccountApprove();
        entity.setAccountType(3);
        entity.setOwnerUserNo(loginUserInfo.getUserNo());
        entity.setOwnerUserName(loginUserInfo.getUserName());
        entity.setMobile(loginUserInfo.getUserMobile());
        entity.setStatus(10);
        ownerLoanAccountApproveDao.saveEntity(entity);

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void ownerLoanAccountApprove(OwnerLoanAccountApproveParam param) {
        Boolean status = param.getStatus();
        OwnerLoanAccountApprove entity = ownerLoanAccountApproveDao.getEntityByKey(param.getId()).orElseThrow(
                PerformanceResultEnum.DATA_NOT_FIND);
        OwnerLoanAccountApprove update = new OwnerLoanAccountApprove();
        update.setId(param.getId());
        if (status) {
            //审批通过
            entity.setStatus(OwnerLoanAccountApproveEnum.Status.APPROVE_PASS.getCode());
            ownerLoanAccountApproveDao.updateEntityByKey(update);
            ownerLoanAccountService.openOwnerLoanAccount(entity.getOwnerUserNo(), entity.getOwnerUserName(), entity.getMobile());
        } else {
            //审批拒绝
            entity.setStatus(OwnerLoanAccountApproveEnum.Status.APPROVE_REFUSE.getCode());
            entity.setRejectReason(param.getRejectReason());
            ownerLoanAccountApproveDao.updateEntityByKey(update);
        }
    }


}
