package com.clx.performance.feign;


import com.clx.performance.interceptor.FeignInterceptor;
import com.msl.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;


@FeignClient(name = "user-service", configuration = {FeignInterceptor.class})
@RequestMapping(value = "/user-service/feign/carrier/driver/user")
public interface FeignUserService {

	/**
	 * 调用支付FeignAuth
	 * @return
	 */
	@GetMapping(value = "/getPaymentServiceAuth")
	Result<String> getPaymentServiceAuth();
}
