package com.clx.performance.dao.impl.settle;


import com.clx.performance.dao.settle.OrderChildSyncTransportRecordDao;
import com.clx.performance.mapper.settle.OrderChildSyncTransportRecordMapper;
import com.clx.performance.model.settle.OrderChildSyncTransportRecord;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author kavin
 * Date 2023-12-08
 * Time 11:42
 */
@Repository
public class OrderChildSyncTransportRecordDaoImpl extends BaseDaoImpl<OrderChildSyncTransportRecordMapper, OrderChildSyncTransportRecord, Integer> implements OrderChildSyncTransportRecordDao {

    @Override
    public List<OrderChildSyncTransportRecord> selectListForJob() {
        return baseMapper.selectList(lQrWrapper().eq(OrderChildSyncTransportRecord::getStatus, 0));
    }

    @Override
    public void updateStatus(String childNo) {
        update(lUdWrapper().eq(OrderChildSyncTransportRecord::getChildNo, childNo)
                .set(OrderChildSyncTransportRecord::getStatus, 2)
        );
    }
}
