package com.clx.performance.dao.impl.loan;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.loan.OwnerLoanAccountRunningWaterRecordDao;
import com.clx.performance.mapper.loan.OwnerLoanAccountRunningWaterRecordMapper;
import com.clx.performance.model.loan.OwnerLoanAccountRunningWaterRecord;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountWaterRecordOfOwnerParam;
import com.clx.performance.param.pc.loan.owner.PageOwnerLoanRunWaterRecordParam;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanAccountRunningWaterRecordVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Objects;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Repository
public class OwnerLoanAccountRunningWaterRecordDaoImpl extends BaseDaoImpl<OwnerLoanAccountRunningWaterRecordMapper, OwnerLoanAccountRunningWaterRecord, Integer> implements OwnerLoanAccountRunningWaterRecordDao {

    @Override
    public IPage<OwnerLoanAccountRunningWaterRecordVO> pageByParam(PageOwnerLoanAccountWaterRecordOfOwnerParam param) {
        Page<OwnerLoanAccountRunningWaterRecordVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }

    @Override
    public IPage<OwnerLoanAccountRunningWaterRecord> pageOwnerLoanRunWaterRecord(Long userNo,
            PageOwnerLoanRunWaterRecordParam param) {
        LambdaQueryWrapper<OwnerLoanAccountRunningWaterRecord> query = new LambdaQueryWrapper<>();
        query.eq(OwnerLoanAccountRunningWaterRecord :: getOwnerUserNo,userNo);
        if(StringUtils.isNotBlank(param.getChildNo())){
            query.eq(OwnerLoanAccountRunningWaterRecord :: getChildNo,param.getChildNo());
        }
        if(Objects.nonNull(param.getRunningWaterNo())){
            query.eq(OwnerLoanAccountRunningWaterRecord :: getRunningWaterNo,param.getRunningWaterNo());
        }
        if(Objects.nonNull(param.getRunningWaterType())){
            query.eq(OwnerLoanAccountRunningWaterRecord :: getRunningWaterType,param.getRunningWaterType());
        }
        if(Objects.nonNull(param.getBeginTime())){
            query.ge(OwnerLoanAccountRunningWaterRecord :: getModifiedTime,param.getEndTime());
        }
        if(StringUtils.isNotBlank(param.getEndTime())){
            query.le(OwnerLoanAccountRunningWaterRecord :: getModifiedTime,param.getEndTime());
        }
        query.orderByDesc(OwnerLoanAccountRunningWaterRecord :: getModifiedTime);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }

    @Override
    public List<OwnerLoanAccountRunningWaterRecord> listOwnerLoanRunWaterRecord(Long userNo,
            PageOwnerLoanRunWaterRecordParam param) {
        LambdaQueryWrapper<OwnerLoanAccountRunningWaterRecord> query = new LambdaQueryWrapper<>();
        query.eq(OwnerLoanAccountRunningWaterRecord :: getOwnerUserNo,userNo);
        if(StringUtils.isNotBlank(param.getChildNo())){
            query.eq(OwnerLoanAccountRunningWaterRecord :: getChildNo,param.getChildNo());
        }
        if(Objects.nonNull(param.getRunningWaterNo())){
            query.eq(OwnerLoanAccountRunningWaterRecord :: getRunningWaterNo,param.getRunningWaterNo());
        }
        if(Objects.nonNull(param.getRunningWaterType())){
            query.eq(OwnerLoanAccountRunningWaterRecord :: getRunningWaterType,param.getRunningWaterType());
        }
        if(Objects.nonNull(param.getBeginTime())){
            query.ge(OwnerLoanAccountRunningWaterRecord :: getModifiedTime,param.getEndTime());
        }
        if(StringUtils.isNotBlank(param.getEndTime())){
            query.le(OwnerLoanAccountRunningWaterRecord :: getModifiedTime,param.getEndTime());
        }
        query.orderByDesc(OwnerLoanAccountRunningWaterRecord :: getModifiedTime);
        return baseMapper.selectList(query);
    }

    @Override
    public OwnerLoanAccountRunningWaterRecord getOneByChildNoAndStatus(String childNo, Integer type) {
        return baseMapper.selectOne(lQrWrapper().eq(OwnerLoanAccountRunningWaterRecord::getChildNo, childNo)
                .eq(OwnerLoanAccountRunningWaterRecord::getRunningWaterType, type)
        );
    }

    @Override
    public List<OwnerLoanAccountRunningWaterRecord> getListByOrderNoAndRunningWaterType(String childNo, Integer runningWaterType) {
        return baseMapper.selectList(lQrWrapper().eq(OwnerLoanAccountRunningWaterRecord::getChildNo, childNo)
                .eq(OwnerLoanAccountRunningWaterRecord::getRunningWaterType, runningWaterType)
                .orderByAsc(OwnerLoanAccountRunningWaterRecord::getId)
        );
    }
}
