package com.clx.performance.dao.impl.loan;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.loan.OwnerLoanAccountApproveDao;
import com.clx.performance.mapper.loan.OwnerLoanAccountApproveMapper;
import com.clx.performance.model.loan.OwnerLoanAccountApprove;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountApproveParam;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Objects;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Repository
public class OwnerLoanAccountApproveDaoImpl extends BaseDaoImpl<OwnerLoanAccountApproveMapper, OwnerLoanAccountApprove, Integer> implements OwnerLoanAccountApproveDao {
    @Override
    public IPage<OwnerLoanAccountApprove> pageOwnerLoanAccountApprove(PageOwnerLoanAccountApproveParam param) {
        LambdaQueryWrapper<OwnerLoanAccountApprove> query = new LambdaQueryWrapper<>();

        if(StringUtils.isNotBlank(param.getOwnerUserNo())){
            query.eq(OwnerLoanAccountApprove :: getOwnerUserNo,param.getOwnerUserNo());
        }
        if(StringUtils.isNotBlank(param.getOwnerUserName())){
            query.like(OwnerLoanAccountApprove :: getOwnerUserName,param.getOwnerUserName());
        }
        if(Objects.nonNull(param.getStatus())){
            query.like(OwnerLoanAccountApprove :: getStatus,param.getStatus());
        }
        if(StringUtils.isNotBlank(param.getMobile())){
            query.eq(OwnerLoanAccountApprove :: getMobile,param.getMobile());
        }
        query.orderByDesc(OwnerLoanAccountApprove :: getId);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);

    }

    @Override
    public List<OwnerLoanAccountApprove> getOwnerLoanAccountApproveList(Long userNo) {
        LambdaQueryWrapper<OwnerLoanAccountApprove> query = new LambdaQueryWrapper<>();
        query.orderByDesc(OwnerLoanAccountApprove :: getId);
        return baseMapper.selectList(query);
    }
}
