/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.util;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1Object;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.nist.NISTNamedCurves;
import cn.com.infosec.asn1.oiw.ElGamalParameter;
import cn.com.infosec.asn1.oiw.OIWObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.DHParameter;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.sec.SECNamedCurves;
import cn.com.infosec.asn1.teletrust.TeleTrusTNamedCurves;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.DSAParameter;
import cn.com.infosec.asn1.x509.RSAPublicKeyStructure;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.asn1.x509.X509ObjectIdentifiers;
import cn.com.infosec.asn1.x9.X962NamedCurves;
import cn.com.infosec.asn1.x9.X962Parameters;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.asn1.x9.X9ECPoint;
import cn.com.infosec.asn1.x9.X9ObjectIdentifiers;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.DHParameters;
import cn.com.infosec.crypto.params.DHPublicKeyParameters;
import cn.com.infosec.crypto.params.DSAParameters;
import cn.com.infosec.crypto.params.DSAPublicKeyParameters;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.crypto.params.ElGamalParameters;
import cn.com.infosec.crypto.params.ElGamalPublicKeyParameters;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import java.io.IOException;
import java.io.InputStream;

public class PublicKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] keyInfoData) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(keyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getAlgorithmId();
        if (algId.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption) || algId.getObjectId().equals(X509ObjectIdentifiers.id_ea_rsa)) {
            RSAPublicKeyStructure pubKey = new RSAPublicKeyStructure((ASN1Sequence)keyInfo.getPublicKey());
            return new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
        }
        if (algId.getObjectId().equals(PKCSObjectIdentifiers.dhKeyAgreement) || algId.getObjectId().equals(X9ObjectIdentifiers.dhpublicnumber)) {
            DHParameter params = new DHParameter((ASN1Sequence)keyInfo.getAlgorithmId().getParameters());
            DERInteger derY = (DERInteger)keyInfo.getPublicKey();
            return new DHPublicKeyParameters(derY.getValue(), new DHParameters(params.getP(), params.getG()));
        }
        if (algId.getObjectId().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter params = new ElGamalParameter((ASN1Sequence)keyInfo.getAlgorithmId().getParameters());
            DERInteger derY = (DERInteger)keyInfo.getPublicKey();
            return new ElGamalPublicKeyParameters(derY.getValue(), new ElGamalParameters(params.getP(), params.getG()));
        }
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_dsa) || algId.getObjectId().equals(OIWObjectIdentifiers.dsaWithSHA1)) {
            DSAParameter params = new DSAParameter((ASN1Sequence)keyInfo.getAlgorithmId().getParameters());
            DERInteger derY = (DERInteger)keyInfo.getPublicKey();
            return new DSAPublicKeyParameters(derY.getValue(), new DSAParameters(params.getP(), params.getQ(), params.getG()));
        }
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            X962Parameters params = new X962Parameters((DERObject)keyInfo.getAlgorithmId().getParameters());
            ECDomainParameters dParams = null;
            if (params.isNamedCurve()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)params.getParameters();
                X9ECParameters ecP = X962NamedCurves.getByOID(oid);
                if (ecP == null && (ecP = SECNamedCurves.getByOID(oid)) == null && (ecP = NISTNamedCurves.getByOID(oid)) == null) {
                    ecP = TeleTrusTNamedCurves.getByOID(oid);
                }
                dParams = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            } else {
                X9ECParameters ecP = new X9ECParameters((ASN1Sequence)params.getParameters());
                dParams = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            }
            DERBitString bits = keyInfo.getPublicKeyData();
            byte[] data = bits.getBytes();
            DEROctetString key = new DEROctetString(data);
            X9ECPoint derQ = new X9ECPoint(dParams.getCurve(), key);
            return new ECPublicKeyParameters(derQ.getPoint(), dParams);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

