/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.communication.multiple;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.communication.Communicator;
import cn.com.infosec.netsign.communication.multiple.Byte2StringRotator;
import cn.com.infosec.netsign.communication.multiple.ByteRotator;
import cn.com.infosec.netsign.communication.multiple.ObjectRotator;
import cn.com.infosec.netsign.communication.multiple.Rotator;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class MultiCommunicator
implements Communicator {
    private static final byte DEFAULT_COMM_FLAG = 0;
    private static final byte C1 = 1;
    private static final byte C2 = 2;
    private Socket socket = null;
    private DataOutputStream out = null;
    private DataInputStream in = null;
    private Rotator rotator = null;
    private byte flag = (byte)2;

    public MultiCommunicator(Socket socket) {
        this.socket = socket;
        try {
            this.out = new DataOutputStream(socket.getOutputStream());
            this.in = new DataInputStream(socket.getInputStream());
        }
        catch (IOException ioEx) {
            ConsoleLogger.logException(ioEx);
        }
    }

    private Rotator getRotator(byte flag) {
        if (flag == 0) {
            return new ObjectRotator();
        }
        if (flag == 1) {
            return new ByteRotator();
        }
        if (flag == 2) {
            return new Byte2StringRotator();
        }
        return null;
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public boolean isClosed() {
        if (this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    public void send(AbstractMessage msg) throws IOException {
        if (this.rotator == null) {
            this.rotator = this.getRotator(this.flag);
        }
        this.rotator.write(msg, this.out);
    }

    public AbstractMessage recv() throws IOException, ClassNotFoundException {
        this.flag = this.parseFlag();
        this.rotator = this.getRotator(this.flag);
        return this.rotator.read(this.in);
    }

    private byte parseFlag() throws IOException {
        this.flag = this.in.readByte();
        if (this.flag != 0 && this.flag != 1 && this.flag != 2) {
            try {
                this.flag = (byte)Integer.parseInt(Character.toString((char)this.flag));
            }
            catch (Exception e) {
                throw new IOException("Unsupport protocol");
            }
        }
        if (this.flag != 0 && this.flag != 1 && this.flag != 2) {
            throw new IOException("Unsupport protocol");
        }
        return this.flag;
    }
}

