/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.jce.provider.JCERSAPublicKey;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.jce.provider.X509CertificateObject;
import cn.com.infosec.jce.provider.X509CertificateObjectFX;
import cn.com.infosec.jce.provider.fastparser.DerUtil;
import cn.com.infosec.jce.provider.fastparser.FastPkcs7;
import cn.com.infosec.jce.provider.fastparser.Item;
import cn.com.infosec.netsign.agent.DNItemReverseUtil;
import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.processors.util.GZipUtil;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.crypto.util.SoftCryptoImpl;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.pool.Pool;
import cn.com.infosec.netsign.pool.Poolable;
import cn.com.infosec.oscca.encryption.SM4CBC;
import cn.com.infosec.oscca.encryption.SM4ECB;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class NetSignAgentUtil {
    public static HashMap digestOIDName;
    public static Pool encLockPool;

    static {
        if (Security.getProvider("INFOSEC") == null) {
            Security.addProvider((Provider)new InfosecProvider());
        }
        digestOIDName = new HashMap();
        digestOIDName.put("1.3.14.3.2.26", "SHA1");
        digestOIDName.put("1.2.840.113549.2.5", "MD5");
        digestOIDName.put("1.2.840.113549.2.2", "MD2");
        digestOIDName.put("2.16.840.1.101.3.4.2.4", "SHA224");
        digestOIDName.put("2.16.840.1.101.3.4.2.1", "SHA256");
        digestOIDName.put("2.16.840.1.101.3.4.2.2", "SHA384");
        digestOIDName.put("2.16.840.1.101.3.4.2.3", "SHA512");
        digestOIDName.put("1.2.840.113549.11.5", "SHA1");
        digestOIDName.put("1.2.840.113549.1.1.11", "SHA256");
        digestOIDName.put("1.2.156.197.1.401", "SM3");
        digestOIDName.put("1.2.156.10197.1.401", "SM3");
        digestOIDName.put("1.2.156.10197.1.501", "SM3");
        digestOIDName.put("1.2.156.197.1.401.2", "SM3-2");
        digestOIDName.put("1.2.156.10197.1.401.2", "SM3-2");
        digestOIDName.put("1.2.156.197.1.401.1", "SM3-1");
        digestOIDName.put("1.2.156.10197.1.401.1", "SM3-1");
        try {
            encLockPool = new Pool("cn.com.infosec.netsign.pool.SamplePoolable", NetSignAgentRes.getEncLock(), null);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static X509Certificate getCertificateFromP7(String p7b) {
        return NetSignAgentUtil.getCertificateFromP7(Base64.decode(p7b));
    }

    public static X509Certificate getCertificateFromP7(byte[] p7b) {
        try {
            FastPkcs7 fxPKCS7 = new FastPkcs7();
            fxPKCS7.pkcs7SignedData(p7b);
            Item signCertItem = fxPKCS7.getSignCert();
            byte[] bsCert = DerUtil.getItemDataAndTag((byte[])p7b, (Item)signCertItem);
            return new X509CertificateObjectFX(bsCert);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    public static byte[] xmlCanonical(byte[] xml) throws Exception {
        byte[] byArray;
        ByteArrayInputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = new ByteArrayInputStream(xml);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(in);
            DOMSource domSource = new DOMSource(doc.getDocumentElement());
            out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.transform(domSource, result);
            byArray = out.toByteArray();
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public static String encode(byte[] bytes) {
        return Base64.encode(bytes);
    }

    public static byte[] decode(String text) throws NetSignAgentException {
        try {
            return Base64.decode(text);
        }
        catch (Exception e) {
            throw new NetSignAgentException(-1011, e.getMessage());
        }
    }

    public static NSMessage createMessage(String processor) {
        NSMessage req = new NSMessage();
        req.setType("request");
        req.setProcessor(processor);
        req.setClientId(NetSignAgentRes.getClientId());
        return req;
    }

    public static byte[] checkOrZip(byte[] bytes, NSMessage req) throws NetSignAgentException {
        try {
            new GZIPInputStream(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            if (!e.getMessage().toLowerCase().startsWith("not in gzip format")) {
                throw new NetSignAgentException(-1014, e.getMessage());
            }
            return NetSignAgentUtil.checkAndZip(bytes, req);
        }
        req.setZipMode(true);
        return bytes;
    }

    public static byte[] checkAndZip(byte[] bytes, NSMessage req) throws NetSignAgentException {
        if (NetSignAgentRes.isZipMode() && bytes.length >= NetSignAgentRes.getMinZipSize()) {
            req.setZipMode(true);
            try {
                return GZipUtil.zip(bytes);
            }
            catch (IOException e) {
                if (NetSignAgent.getDebugWriter() != null) {
                    NetSignAgent.getDebugWriter().println(new Date() + " Zip message failed, " + "the error code is " + -1012 + ", the error is " + e.getMessage());
                }
                throw new NetSignAgentException(-1012, e.getMessage());
            }
        }
        req.setZipMode(false);
        return bytes;
    }

    public static byte[] checkAndEncrypt(byte[] bytes, NSMessage req) throws NetSignAgentException {
        if (NetSignAgentRes.getCommunicateMode() == 0) {
            req.setCommunicateMode(0);
            req.setEncKey(NetSignAgentRes.getEncSecKey());
            req.setKeyHash(NetSignAgentRes.getKeyHash());
            try {
                return SoftCryptoImpl.encrypt(SoftCryptoImpl.RC4, NetSignAgentRes.getSecKey(), bytes, null);
            }
            catch (Exception e) {
                if (NetSignAgent.getDebugWriter() != null) {
                    NetSignAgent.getDebugWriter().println(new Date() + " Encrypt message failed, " + "the error code is " + -1015 + ", the error is " + e.getMessage());
                }
                throw new NetSignAgentException(-1015, e.getMessage());
            }
        }
        req.setCommunicateMode(1);
        return bytes;
    }

    public static byte[] checkAndDecrypt(byte[] bytes, int commMode) throws NetSignAgentException {
        if (commMode == 0) {
            try {
                return SoftCryptoImpl.decrypt(SoftCryptoImpl.RC4, NetSignAgentRes.getSecKey(), bytes, "12345678".getBytes());
            }
            catch (Exception e) {
                if (NetSignAgent.getDebugWriter() != null) {
                    NetSignAgent.getDebugWriter().println(new Date() + " Decrypt message failed, " + "the error code is " + -1016 + ", the error is " + e.getMessage());
                }
                throw new NetSignAgentException(-1016, e.getMessage());
            }
        }
        return bytes;
    }

    public static byte[] checkAndUnzip(byte[] bytes, boolean isZipped) throws NetSignAgentException {
        if (!isZipped) {
            return bytes;
        }
        try {
            return GZipUtil.unzip(bytes);
        }
        catch (IOException e) {
            if (NetSignAgent.getDebugWriter() != null) {
                NetSignAgent.getDebugWriter().println(new Date() + " Unzip message failed, " + "the error code is " + -1013 + ", the error is " + e.getMessage());
            }
            throw new NetSignAgentException(-1013, e.getMessage());
        }
    }

    public static void checkAndSetTSA(String tsaText, NSMessage req) throws NetSignAgentException {
        if (tsaText == null) {
            req.setUsedTSA(false);
        } else {
            req.setUsedTSA(true);
            req.setTSAText(NetSignAgentUtil.decode(tsaText));
        }
    }

    public static NetSignResult attachedVerifyResult(NSMessageOpt res) throws NetSignAgentException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        byte[] plainText = NetSignAgentUtil.checkAndDecrypt(res.getPlainText(), res.getCommunicateMode());
        plainText = NetSignAgentUtil.checkAndUnzip(plainText, res.isZipMode());
        map.put("Result_Num", String.valueOf(res.getResult()));
        map.put("Byte_Array_Plain_Text", plainText);
        if (res.isTransCert()) {
            map.put("X509Certificate_Sign_Cert", res.getCert());
        }
        if (res.getDigestAlg() != null) {
            map.put("DIGEST_ALG", res.getDigestAlg());
        }
        map.put("Sign_Subject", res.getSignSubject());
        map.put("Sign_Ser_Number", res.getSignSerNumber());
        map.put("Sign_Issuer_Subject", res.getSignIssuerSubject());
        map.put("Sign_Start_Time", res.getSignStartTime());
        map.put("Sign_End_Time", res.getSignEndtime());
        if (res.getSignCertType() != null) {
            map.put("Sign_Cert_Type", res.getSignCertType());
        }
        if (res.getUsedTSA()) {
            map.put("TSA_Gen_Time", res.getTSAGenerateTime());
        }
        return new NetSignResult(map);
    }

    public static ArrayList pdfVerifyResult(NSMessageOpt res) {
        return res.getPDFVerifyResults();
    }

    public static ArrayList xmlVerifyResult(NSMessageOpt res) {
        return res.getXmlVerifyResults();
    }

    public static NetSignResult detachedVerifyResult(NSMessageOpt res) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (res.isTransCert()) {
            map.put("X509Certificate_Sign_Cert", res.getCert());
        }
        if (res.getDigestAlg() != null) {
            map.put("DIGEST_ALG", res.getDigestAlg());
        }
        map.put("Sign_Subject", res.getSignSubject());
        map.put("Sign_Ser_Number", res.getSignSerNumber());
        map.put("Sign_Issuer_Subject", res.getSignIssuerSubject());
        map.put("Sign_Start_Time", res.getSignStartTime());
        map.put("Sign_End_Time", res.getSignEndtime());
        if (res.getSignCertType() != null) {
            map.put("Sign_Cert_Type", res.getSignCertType());
        }
        if (res.getUsedTSA()) {
            map.put("TSA_Gen_Time", res.getTSAGenerateTime());
        }
        return new NetSignResult(map);
    }

    public static NetSignResult TSASigVerifyResult(NSMessageOpt res) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TSA_Gen_Time", res.getTSAGenerateTime());
        return new NetSignResult(map);
    }

    public static NetSignResult rawVerifyResult(NSMessageOpt res) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (res.getUsedTSA()) {
            map.put("TSA_Gen_Time", res.getTSAGenerateTime());
        }
        if (res.getDigestAlg() != null) {
            map.put("DIGEST_ALG", res.getDigestAlg());
        }
        if (res.getProcessor().equals("PBCRAWVerifyProcessor")) {
            map.put("Sign_Subject", res.getSignSubject());
            map.put("Sign_Ser_Number", res.getSignSerNumber());
            map.put("Sign_Issuer_Subject", res.getSignIssuerSubject());
            map.put("Sign_Start_Time", res.getSignStartTime());
            map.put("Sign_End_Time", res.getSignEndtime());
        }
        return new NetSignResult(map);
    }

    public static NetSignResult signatureResult(NSMessage res) throws NetSignAgentException {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        byte[] signText = NetSignAgentUtil.checkAndDecrypt(res.getCryptoText(), res.getCommunicateMode());
        signText = NetSignAgentUtil.checkAndUnzip(signText, res.isZipMode());
        map.put("Base64_Signed_Text", signText);
        if (res.getUsedTSA()) {
            map.put("Base64_TSA_Text", res.getTSAText());
        }
        return new NetSignResult(map);
    }

    public static NetSignResult xmlSignatureResult(NSMessage res) throws NetSignAgentException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        byte[] signText = NetSignAgentUtil.checkAndDecrypt(res.getCryptoText(), res.getCommunicateMode());
        signText = NetSignAgentUtil.checkAndUnzip(signText, res.isZipMode());
        map.put("Base64_Signed_Text", signText);
        map.put("Signature_Id", res.getXmlSigID());
        if (res.getUsedTSA()) {
            map.put("Base64_TSA_Text", res.getTSAText());
        }
        return new NetSignResult(map);
    }

    public static NetSignResult pdfEncryptResult(NSMessage res) throws NetSignAgentException {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put("Pdf_Encrypt_Text", res.getCryptoText());
        return new NetSignResult(map);
    }

    public static NetSignResult pdfSignatureResult(NSMessage res) throws NetSignAgentException {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put("Base64_Signed_Text", res.getCryptoText());
        return new NetSignResult(map);
    }

    public static NetSignResult envelopeResult(NSMessage res) throws NetSignAgentException {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        byte[] cryptoText = NetSignAgentUtil.checkAndUnzip(res.getCryptoText(), res.isZipMode());
        map.put("Base64_Enveloped_Text", cryptoText);
        return new NetSignResult(map);
    }

    public static NetSignResult decryptEnvelopeResult(NSMessageOpt res) throws NetSignAgentException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        byte[] plainText = NetSignAgentUtil.checkAndDecrypt(res.getPlainText(), res.getCommunicateMode());
        plainText = NetSignAgentUtil.checkAndUnzip(plainText, res.isZipMode());
        map.put("Byte_Array_Plain_Text", plainText);
        map.put("Enc_Subject", res.getEncSubject());
        map.put("Enc_Ser_Number", res.getEncSerNumber());
        map.put("Enc_Issuer_Subject", res.getEncIssuerSubject());
        map.put("Enc_Start_Time", res.getEncStartTime());
        map.put("Enc_End_Time", res.getEncEndtime());
        if (res.getDigestAlg() != null) {
            map.put("DIGEST_ALG", res.getDigestAlg());
        }
        if (res.getSymmetricalAlg() != null) {
            map.put("Enc_Alg", res.getSymmetricalAlg());
        }
        if (res.getSignSubject() != null) {
            map.put("Sign_Subject", res.getSignSubject());
            map.put("Sign_Ser_Number", res.getSignSerNumber());
            map.put("Sign_Issuer_Subject", res.getSignIssuerSubject());
            map.put("Sign_Start_Time", res.getSignStartTime());
            map.put("Sign_End_Time", res.getSignEndtime());
        }
        return new NetSignResult(map);
    }

    public static PublicKey transpublickey(PublicKey pubkey) throws NetSignAgentException {
        try {
            if (pubkey instanceof JCERSAPublicKey || pubkey instanceof JCESM2PublicKey || pubkey instanceof SM2PublicKey) {
                return pubkey;
            }
            RSAPublicKey rsapbkey = (RSAPublicKey)pubkey;
            return KeyFactory.getInstance("RSA", "INFOSEC").generatePublic(new RSAPublicKeySpec(rsapbkey.getModulus(), rsapbkey.getPublicExponent()));
        }
        catch (Exception ex) {
            throw new NetSignAgentException(ex.getMessage());
        }
    }

    public static X509Certificate transcertificate(X509Certificate cert) throws NetSignAgentException {
        try {
            if (cert instanceof X509CertificateObject) {
                return cert;
            }
            ByteArrayInputStream binput = new ByteArrayInputStream(cert.getEncoded());
            return (X509Certificate)CertificateFactory.getInstance("X.509", "INFOSEC").generateCertificate(binput);
        }
        catch (Exception ex) {
            throw new NetSignAgentException(ex.getMessage());
        }
    }

    public static void debug(String msg, AbstractMessage am) {
        if (NetSignAgent.getDebugWriter() != null) {
            NetSignAgent.getDebugWriter().println(String.valueOf(msg) + (am != null ? am.getString() : ""));
        }
    }

    public static String getDN(String dn) {
        if (dn == null || dn.equals("")) {
            return dn;
        }
        switch (NetSignAgentRes.getOrderDN()) {
            case 0: {
                return dn;
            }
            case 1: {
                if (DNItemReverseUtil.isDNReversed(dn)) {
                    return DNItemReverseUtil.reverse(dn);
                }
                return dn;
            }
            case 2: {
                if (dn.startsWith("CN=") || dn.startsWith("cn=")) {
                    return NetSignAgentUtil.turnDNString(dn);
                }
                return dn;
            }
        }
        return dn;
    }

    public static boolean compareDN(String srcDN, String destDN) {
        srcDN = NetSignAgentUtil.removeTrans(srcDN);
        String temp = NetSignAgentUtil.turnDNString(srcDN);
        return srcDN.equals(destDN = NetSignAgentUtil.removeTrans(destDN)) || temp.equals(destDN);
    }

    public static String turnDNString(String dn) {
        String[] temp = dn.split(",\\w+=");
        String turnDN = "";
        ArrayList<String> temp2 = new ArrayList<String>();
        String s = ",\\w+=";
        Pattern pat = Pattern.compile(s);
        Matcher mat = pat.matcher(dn);
        while (mat.find()) {
            temp2.add(mat.group(0).substring(1));
        }
        int j = temp2.size() - 1;
        int i = temp.length - 1;
        while (i > 0) {
            if (j >= 0) {
                turnDN = String.valueOf(turnDN) + temp2.get(j) + temp[i].trim() + ",";
                --j;
            }
            --i;
        }
        turnDN = String.valueOf(turnDN) + temp[0];
        return turnDN;
    }

    public static String removeTrans(String rawStr) {
        rawStr = rawStr.trim();
        rawStr = rawStr.replace("\\\\", "#");
        rawStr = rawStr.replace("\\", "");
        rawStr = rawStr.replace("#", "\\");
        return rawStr;
    }

    public static NetSignResult barcodeResult(NSMessageOpt res) throws NetSignAgentException {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put("BarCode_Symbology", res.getBcSymbology());
        return new NetSignResult(map);
    }

    public static byte[] digest(byte[] msg, String alg) {
        try {
            MessageDigest md = MessageDigest.getInstance(alg, "INFOSEC");
            return md.digest(msg);
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
            return null;
        }
    }

    public static byte[] getSignatureInPKCS7(byte[] p7, X509Certificate cert) {
        PublicKey k = cert.getPublicKey();
        if (k instanceof RSAPublicKey) {
            RSAPublicKey rsaK = (RSAPublicKey)k;
            int keyLength = rsaK.getModulus().bitLength() / 8;
            byte[] signed = new byte[keyLength];
            System.arraycopy(p7, p7.length - keyLength, signed, 0, keyLength);
            return signed;
        }
        int i = p7.length - 64;
        byte[] signed = null;
        boolean matched = false;
        while (i > 0) {
            if (p7[i] == 4) {
                int l = 0;
                if (p7[i + 1] == 81) {
                    l = 0xFF & p7[i + 2];
                    if (i + 2 + l == p7.length) {
                        matched = true;
                    }
                } else {
                    l = 0xFF & p7[i + 1];
                    if (i + 1 + l == p7.length) {
                        matched = true;
                    }
                }
                if (matched) {
                    signed = new byte[l];
                    System.arraycopy(p7, p7.length - l, signed, 0, l);
                    return signed;
                }
            }
            --i;
        }
        return null;
    }

    public static void setVerifyResult(byte[] plainText, X509Certificate cert, boolean needCert, NetSignResult result) {
        if (plainText != null && plainText.length > 0) {
            result.setResult("Byte_Array_Plain_Text", plainText);
        }
        if (cert != null) {
            result.setResult("Sign_Subject", cert.getSubjectDN().getName());
            result.setResult("Sign_Ser_Number", cert.getSerialNumber().toString(16).toUpperCase());
            result.setResult("Sign_Issuer_Subject", cert.getIssuerDN().getName());
            result.setResult("Sign_Start_Time", String.valueOf(cert.getNotBefore().getTime()));
            result.setResult("Sign_End_Time", String.valueOf(cert.getNotAfter().getTime()));
            if (needCert) {
                result.setResult("X509Certificate_Sign_Cert", cert);
            }
        }
    }

    public static String dealSN(String sn) {
        switch (NetSignAgentRes.getSNMode()) {
            case 1: {
                sn = sn.length() % 2 == 0 ? sn : "0" + sn;
                return sn;
            }
            case 2: {
                BigInteger snbi = new BigInteger(sn, 16);
                return snbi.toString(10);
            }
        }
        return sn;
    }

    public static byte[] catText4TransValue(byte[][] text) {
        int segLength = text.length;
        byte[] buf = NetSignAgentUtil.getDataLength(segLength);
        int i = 0;
        while (i < text.length) {
            byte[] tmp = new byte[buf.length + 4 + text[i].length];
            System.arraycopy(buf, 0, tmp, 0, buf.length);
            System.arraycopy(NetSignAgentUtil.getDataLength(text[i].length), 0, tmp, buf.length, 4);
            System.arraycopy(text[i], 0, tmp, buf.length + 4, text[i].length);
            buf = tmp;
            ++i;
        }
        return buf;
    }

    public static byte[][] splitTextFromTransValue(byte[] value) {
        byte[] intBs = new byte[4];
        System.arraycopy(value, 0, intBs, 0, 4);
        int segCount = NetSignAgentUtil.bytes2Int(intBs, false);
        int pos = 4;
        byte[][] values = new byte[segCount][];
        int i = 0;
        while (i < segCount) {
            System.arraycopy(value, pos, intBs, 0, 4);
            int segLen = NetSignAgentUtil.bytes2Int(intBs, false);
            byte[] tmp = new byte[segLen];
            System.arraycopy(value, pos + 4, tmp, 0, segLen);
            values[i] = tmp;
            pos = pos + 4 + segLen;
            ++i;
        }
        return values;
    }

    public static byte[] getDataLength(int intLen) {
        byte[] result = new byte[]{(byte)(0xFF & intLen >> 24), (byte)(0xFF & intLen >> 16), (byte)(0xFF & intLen >> 8), (byte)(0xFF & intLen >> 0)};
        return result;
    }

    public static int bytes2Int(byte[] bytes, boolean desc) {
        if (bytes == null) {
            return 0;
        }
        if (bytes.length < 4) {
            byte[] tmp = new byte[4];
            if (!desc) {
                System.arraycopy(bytes, 0, tmp, 4 - bytes.length, bytes.length);
            } else {
                System.arraycopy(bytes, 0, tmp, 0, bytes.length);
            }
            bytes = tmp;
        }
        if (!desc) {
            return bytes[0] << 24 | bytes[1] << 16 & 0xFF0000 | bytes[2] << 8 & 0xFF00 | bytes[3] & 0xFF;
        }
        return bytes[3] << 24 | bytes[2] << 16 & 0xFF0000 | bytes[1] << 8 & 0xFF00 | bytes[0] & 0xFF;
    }

    public static byte[] symmCipherSM4(byte[] plain, byte[] key, byte[] iv, int cipherMod) throws Exception {
        byte[] cipher = null;
        if (iv == null) {
            SM4ECB sm4 = new SM4ECB(cipherMod);
            sm4.init(key);
            sm4.update(plain);
            cipher = sm4.doFinal();
        } else {
            SM4CBC sm4 = new SM4CBC(cipherMod);
            sm4.init(key, iv);
            sm4.update(plain);
            cipher = sm4.doFinal();
        }
        return cipher;
    }

    public static byte[] symmCipher(byte[] plain, byte[] key, byte[] iv, String alg, String mod, int cipherMod) throws Exception {
        SecretKeySpec sk = new SecretKeySpec(key, alg);
        IvParameterSpec ivp = null;
        if (iv != null) {
            ivp = new IvParameterSpec(iv);
        }
        if (mod != null) {
            alg = String.valueOf(alg) + mod;
        }
        Cipher c = Cipher.getInstance(alg);
        if (ivp != null) {
            c.init(cipherMod, (Key)sk, ivp);
        } else {
            c.init(cipherMod, sk);
        }
        return c.doFinal(plain);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void symmCipherSM4(InputStream in, OutputStream out, byte[] key, byte[] iv, int cipherMod) throws Exception {
        block12: {
            if (iv != null) break block12;
            SM4ECB sm4 = new SM4ECB(cipherMod);
            sm4.init(key);
            Poolable lock = encLockPool.getObject();
            try {
                int left = in.available();
                while (true) {
                    block13: {
                        if (left > 0) break block13;
                        byte[] cipher = sm4.doFinal();
                        if (cipher != null) {
                            out.write(cipher);
                            out.flush();
                        }
                        break;
                    }
                    byte[] buf = null;
                    buf = new byte[0xA00000];
                    int readed = in.read(buf);
                    byte[] cipher = sm4.update(buf, 0, readed);
                    if (cipher != null) {
                        out.write(cipher);
                        out.flush();
                    }
                    left -= readed;
                }
            }
            catch (Throwable throwable) {
                Object var11_19 = null;
                encLockPool.freeObject(lock);
                throw throwable;
            }
            {
                Object var11_20 = null;
                encLockPool.freeObject(lock);
                return;
            }
        }
        SM4CBC sm4 = new SM4CBC(cipherMod);
        sm4.init(key, iv);
        Poolable lock = encLockPool.getObject();
        try {
            int left = in.available();
            while (true) {
                block14: {
                    if (left > 0) break block14;
                    byte[] cipher = sm4.doFinal();
                    if (cipher != null) {
                        out.write(cipher);
                        out.flush();
                    }
                    break;
                }
                byte[] buf = null;
                buf = new byte[0xA00000];
                int readed = in.read(buf);
                byte[] cipher = sm4.update(buf, 0, readed);
                if (cipher != null) {
                    out.write(cipher);
                    out.flush();
                }
                left -= readed;
            }
        }
        catch (Throwable throwable) {
            Object var11_21 = null;
            encLockPool.freeObject(lock);
            throw throwable;
        }
        {
            Object var11_22 = null;
            encLockPool.freeObject(lock);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void symmCipher(InputStream in, OutputStream out, byte[] key, byte[] iv, String alg, String mod, int cipherMod) throws Exception {
        SecretKeySpec sk = new SecretKeySpec(key, alg);
        IvParameterSpec ivp = null;
        if (iv != null) {
            ivp = new IvParameterSpec(iv);
        }
        if (mod != null) {
            alg = String.valueOf(alg) + mod;
        }
        Cipher c = Cipher.getInstance(alg, "INFOSEC");
        if (ivp != null) {
            c.init(cipherMod, (Key)sk, ivp);
        } else {
            c.init(cipherMod, sk);
        }
        Poolable lock = encLockPool.getObject();
        try {
            int left = in.available();
            while (true) {
                block10: {
                    if (left > 0) break block10;
                    byte[] cipher = c.doFinal();
                    if (cipher != null) {
                        out.write(cipher);
                        out.flush();
                    }
                    break;
                }
                byte[] buf = null;
                buf = new byte[0xA00000];
                int readed = in.read(buf);
                byte[] cipher = c.update(buf, 0, readed);
                if (cipher != null) {
                    out.write(cipher);
                    out.flush();
                }
                left -= readed;
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            encLockPool.freeObject(lock);
            throw throwable;
        }
        {
            Object var15_17 = null;
            encLockPool.freeObject(lock);
            return;
        }
    }

    public static PublicKey getRSAPublicKey(byte[] pubkey) throws NetSignAgentException {
        try {
            KeyFactory keyFactory2;
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pubkey);
            PublicKey publicKey = null;
            try {
                keyFactory2 = KeyFactory.getInstance("RSA");
                publicKey = keyFactory2.generatePublic(keySpec);
            }
            catch (Exception keyFactory2) {
                // empty catch block
            }
            try {
                keyFactory2 = KeyFactory.getInstance("EC");
                publicKey = keyFactory2.generatePublic(keySpec);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (publicKey == null) {
                throw new NetSignAgentException("Parse PublicKey error");
            }
            return publicKey;
        }
        catch (Exception e) {
            throw new NetSignAgentException("Parse PublicKey error");
        }
    }

    public static void main(String[] args) {
        String signed = "MIIDyQYKKoEcz1UGAQQCAqCCA7kwggO1AgEBMQ4wDAYIKoEcz1UBgxEFADAMBgoqgRzPVQYBBAIBoIICujCCArYwggJaoAMCAQICBRACiTiTMAwGCCqBHM9VAYN1BQAwXDELMAkGA1UEBhMCQ04xMDAuBgNVBAoMJ0NoaW5hIEZpbmFuY2lhbCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTEbMBkGA1UEAwwSQ0ZDQSBURVNUIFNNMiBPQ0ExMB4XDTE2MDcxMTAzMTUwMVoXDTIwMDcwMTE1NTk1OVowejELMAkGA1UEBhMCY24xFTATBgNVBAoMDENGQ0EgVEVTVCBDQTEOMAwGA1UECwwFQ05BUFMxFDASBgNVBAsMC0VudGVycHJpc2VzMS4wLAYDVQQDDCUwNDFAWjMxMzY1NjAwMDAxOUBTTTJfUFpIQ0NCQDAwMDAwMDAzMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE0WPSq0X/BlYXzyD0YurRI1QuFSdTGizsFZyzXD+CaQkqV2m6IOZ+7ysS6ZCiiiVG86t/eF0PtgfQxBE+3OkEZqOB6DCB5TAfBgNVHSMEGDAWgBRr/hjaj0I6prhtsy6Igzo0osEw4TBIBgNVHSAEQTA/MD0GCGCBHIbvKgEBMDEwLwYIKwYBBQUHAgEWI2h0dHA6Ly93d3cuY2ZjYS5jb20uY24vdXMvdXMtMTQuaHRtMDcGA1UdHwQwMC4wLKAqoCiGJmh0dHA6Ly91Y3JsLmNmY2EuY29tLmNuL1NNMi9jcmw5NzguY3JsMAsGA1UdDwQEAwID6DAdBgNVHQ4EFgQU9PijS0jFNf8Cjs6cXVPzn0lnmB0wEwYDVR0lBAwwCgYIKwYBBQUHAwIwDAYIKoEcz1UBg3UFAANIADBFAiEAyRdXAXsIYZTlhcud5qrkwQLHRIUgNXKtMtaoZUY4PQMCIC5+K7LliVsIPevXTlrzAbCCFatj2a/zcAe6foUn6vn8MYHTMIHQAgEBMGUwXDELMAkGA1UEBhMCQ04xMDAuBgNVBAoMJ0NoaW5hIEZpbmFuY2lhbCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTEbMBkGA1UEAwwSQ0ZDQSBURVNUIFNNMiBPQ0ExAgUQAok4kzAMBggqgRzPVQGDEQUAMA0GCSqBHM9VAYItAQUABEcwRQIhAM9S65Xki2vqDA5W9YNMBpCXpfTh9AM7yvx1xi/tgS4YAiAxYnDZ4HchdOS8OYSDQwONAefRsGuHijuVCl/WH4KdUA==";
        X509Certificate cert = NetSignAgentUtil.getCertificateFromP7(signed);
        System.out.println("\u8bc1\u4e66DN:" + cert.getSubjectDN().getName() + "\n\u8bc1\u4e66\u6709\u6548\u671f\u8d77\u59cb\u65e5:" + cert.getNotBefore() + "\n\u8bc1\u4e66\u6709\u6548\u671f\u7ed3\u675f\u65e5\u671f:" + cert.getNotAfter() + "\n\u8bc1\u4e66SN:" + cert.getSerialNumber().toString(16) + "\n\u516c\u94a5\u7b97\u6cd5:" + cert.getPublicKey().getAlgorithm() + "\n\u8bc1\u4e66\u516c\u94a5:" + Base64.encode(cert.getPublicKey().getEncoded()) + "\n");
    }

    public static String[] genKeyPairResult(NSMessage res) throws NetSignAgentException {
        return new String(NetSignAgentUtil.checkAndDecrypt(res.getCryptoText(), res.getCommunicateMode())).split(":");
    }
}

