package com.clx.performance.service.impl.broker;

import com.alibaba.fastjson.JSON;
import com.clx.performance.common.MqDelay;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyBrokerConstants;
import com.clx.performance.service.broker.OrderChildBrokerMqService;
import com.clx.performance.vo.mq.broker.BrokerOrderChildSyncMqParam;
import com.clx.performance.vo.mq.broker.BrokerOrderChildUpdateMqParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class OrderChildBrokerMqServiceImpl implements OrderChildBrokerMqService {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public void orderChildSync(String childNo) {
        BrokerOrderChildSyncMqParam mq = new BrokerOrderChildSyncMqParam();
        mq.setChildNo(childNo);

        MqDelay delay =
                new MqDelay<>(RabbitKeyBrokerConstants.DEFAULT_EXCHANGE,
                        RabbitKeyBrokerConstants.ORDER_CHILD_SYNC_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyBrokerConstants.DEFAULT_EXCHANGE,
                RabbitKeyBrokerConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void orderChildUpdate(String childNo) {
        BrokerOrderChildUpdateMqParam mq = new BrokerOrderChildUpdateMqParam();
        mq.setChildNo(childNo);

        MqDelay delay =
                new MqDelay<>(RabbitKeyBrokerConstants.DEFAULT_EXCHANGE,
                        RabbitKeyBrokerConstants.ORDER_CHILD_UPDATE_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyBrokerConstants.DEFAULT_EXCHANGE,
                RabbitKeyBrokerConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void orderChildUpdate(List<String> childNoList) {

        for (String childNo : childNoList) {
            orderChildUpdate(childNo);
        }
    }

}
