package com.clx.performance.service.impl;

import com.clx.performance.dao.OrderChildOperateLimitConfigDao;
import com.clx.performance.enums.EnabledStatusEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.OrderChildOperateLimitConfig;
import com.clx.performance.param.pc.SaveOrderChildOperateLimitConfigParam;
import com.clx.performance.service.OrderChildOperateLimitConfigService;
import com.clx.performance.struct.OrderChildOperateLimitConfigStruct;
import com.clx.performance.vo.pc.OrderChildOperateLimitConfigVO;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @author jiangwj
 * Date 2024-08-07
 * Time 16:29
 */
@Service
@AllArgsConstructor
public class OrderChildOperateLimitConfigServiceImpl implements OrderChildOperateLimitConfigService {

    private final OrderChildOperateLimitConfigDao dao;

    private final OrderChildOperateLimitConfigStruct struct;

    @Override
    public OrderChildOperateLimitConfigVO listConfig() {
        return struct.convertVO(dao.listConfig());
    }

    @Override
    public OrderChildOperateLimitConfigVO getDetail(Integer id) {
        OrderChildOperateLimitConfig config = dao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        return struct.convertVO(config);
    }

    @Override
    public void updateConfig(SaveOrderChildOperateLimitConfigParam param) {
        OrderChildOperateLimitConfig config = new OrderChildOperateLimitConfig();
        config.setId(param.getId());
        config.setAllowUploadDistance(param.getAllowUploadDistance());
        dao.updateConfig(config);
    }

    @Override
    public void enableConfig(Integer id) {
        dao.updateStatus(id, EnabledStatusEnum.ENABLE.getCode());
    }

    @Override
    public void disableConfig(Integer id) {
        dao.updateStatus(id, EnabledStatusEnum.DISABLE.getCode());
    }
}
