package com.clx.performance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.OwnerRunningWaterRecord;
import com.clx.performance.param.pc.PageOwnerAccountRunningWaterParam;
import com.clx.performance.param.pc.PagePlatformMarginAccountParam;
import com.clx.performance.param.pc.PagePlatformPrepaidFreightAccountParam;
import com.clx.performance.sqlProvider.OwnerRunningWaterRecordSqlProvider;
import com.clx.performance.vo.pc.OwnerAccountRunningWaterRecordVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.SelectProvider;

/**
 * 货主流水记录
 */
@Mapper
public interface OwnerRunningWaterRecordMapper extends BaseMapper<OwnerRunningWaterRecord> {

    @SelectProvider(type = OwnerRunningWaterRecordSqlProvider.class, method = "marginAccountPageList")
    IPage<OwnerAccountRunningWaterRecordVO> marginAccountPageList(Page<OwnerAccountRunningWaterRecordVO> page, PagePlatformMarginAccountParam param);

    @SelectProvider(type = OwnerRunningWaterRecordSqlProvider.class, method = "prepaidFreightAccountPageList")
    IPage<OwnerAccountRunningWaterRecordVO> prepaidFreightAccountPageList(Page<OwnerAccountRunningWaterRecordVO> page, PagePlatformPrepaidFreightAccountParam param);

    @SelectProvider(type = OwnerRunningWaterRecordSqlProvider.class, method = "ownerAccountRunningWaterPageList")
    IPage<OwnerAccountRunningWaterRecordVO> ownerAccountRunningWaterPageList(Page<OwnerAccountRunningWaterRecordVO> page, PageOwnerAccountRunningWaterParam param);
}