package com.clx.performance.dao.impl.settle;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.SettlementOwnerDao;
import com.clx.performance.enums.settle.SettlementOwnerEnum;
import com.clx.performance.mapper.settle.SettlementOwnerMapper;
import com.clx.performance.model.settle.SettlementOwner;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerParam;
import com.msl.common.base.Optional;
import com.clx.performance.param.pc.owner.PageOwnerSettlementParam;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Objects;

/**
 * @Author: aiqinguo
 * @Description: 货主结算单
 * @Date: 2023-10-11 18:04:09
 * @Version: 1.0
 */
@Repository
public class SettlementOwnerDaoImpl extends BaseDaoImpl<SettlementOwnerMapper, SettlementOwner, Integer> implements SettlementOwnerDao {
    @Override
    public List<SettlementOwner> getMergeSettlementNos(String settlementNo) {
        return super.list(lQrWrapper()
                .eq(SettlementOwner::getSettlementNo, settlementNo)
                .eq(SettlementOwner::getMergeStatus, SettlementOwnerEnum.MergeStatus.YES.getCode())
                .orderByDesc(SettlementOwner::getId));
    }

    @Override
    public boolean updateStatusBySettlementNo(String settlementNo, Integer status) {
        return update(lUdWrapper()
                .eq(SettlementOwner::getSettlementNo, settlementNo)
                .set(SettlementOwner::getStatus, status)
        );
    }

    @Override
    public boolean updatePayment(SettlementOwner settlementOwner) {
        return update(lUdWrapper()
                .eq(SettlementOwner::getSettlementNo, settlementOwner.getSettlementNo())
                .set(SettlementOwner::getStatus, settlementOwner.getStatus())
                .set(SettlementOwner::getPayee, settlementOwner.getPayee())
                .set(SettlementOwner::getPayeeBankCardNo, settlementOwner.getPayeeBankCardNo())
                .set(SettlementOwner::getPayeeBankName, settlementOwner.getPayeeBankName())
                .set(SettlementOwner::getPaymentImg, settlementOwner.getPaymentImg())
                .set(SettlementOwner::getPaymentBankCardNo, settlementOwner.getPaymentBankCardNo())
                .set(SettlementOwner::getPaymentBankName, settlementOwner.getPaymentBankName())
        );
    }

    @Override
    public IPage<SettlementOwner> pageCarrierSettlementOwner(PageCarrierSettlementOwnerParam param) {
        LambdaQueryWrapper<SettlementOwner> query = new LambdaQueryWrapper<>();
        if(Objects.nonNull(param.getOwnerUserNo())){
            query.eq(SettlementOwner :: getOwnerUserNo,param.getOwnerUserNo());
        }
        if(StringUtils.isNotBlank(param.getSettlementNo())){
            query.eq(SettlementOwner :: getSettlementNo,param.getSettlementNo());
        }
        if(Objects.nonNull(param.getStatus())){
            query.eq(SettlementOwner :: getStatus,param.getStatus());
        }
        query.orderByDesc(SettlementOwner :: getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(),param.getPageSize()),query);

    }

    @Override
    public Optional<SettlementOwner> selectBySettlementNo(String settlementNo) {
        return Optional.of(settlementNo)
                .map(item -> lQrWrapper()
                        .eq(SettlementOwner::getSettlementNo, item)
                        .eq(SettlementOwner::getMergeStatus, SettlementOwnerEnum.MergeStatus.NO.getCode()))
                .map(super::getOne);
    }

    @Override
    public IPage<SettlementOwner> pageSettlementOwner(PageOwnerSettlementParam param) {
        LambdaQueryWrapper<SettlementOwner> query = new LambdaQueryWrapper<>();
        if(Objects.nonNull(param.getOrderNo())){
            query.eq(SettlementOwner :: getOrderNo,param.getOrderNo());
        }
        if(StringUtils.isNotBlank(param.getSettlementNo())){
            query.eq(SettlementOwner :: getSettlementNo,param.getSettlementNo());
        }
        query.orderByDesc(SettlementOwner :: getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(),param.getPageSize()),query);
    }
}
