package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.OwnerRunningWaterRecordDao;
import com.clx.performance.mapper.OwnerRunningWaterRecordMapper;
import com.clx.performance.model.OwnerRunningWaterRecord;
import com.clx.performance.param.pc.PageOwnerAccountRunningWaterParam;
import com.clx.performance.param.pc.PagePlatformMarginAccountParam;
import com.clx.performance.param.pc.PagePlatformPrepaidFreightAccountParam;
import com.clx.performance.vo.pc.OwnerAccountRunningWaterRecordVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

@Repository
public class OwnerRunningWaterRecordDaoImpl extends BaseDaoImpl<OwnerRunningWaterRecordMapper, OwnerRunningWaterRecord, Integer> implements OwnerRunningWaterRecordDao {

    @Override
    public IPage<OwnerAccountRunningWaterRecordVO> marginAccountPageList(PagePlatformMarginAccountParam param) {
        Page<OwnerAccountRunningWaterRecordVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.marginAccountPageList(page, param);
    }

    @Override
    public IPage<OwnerAccountRunningWaterRecordVO> prepaidFreightAccountPageList(PagePlatformPrepaidFreightAccountParam param) {
        Page<OwnerAccountRunningWaterRecordVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.prepaidFreightAccountPageList(page, param);
    }

    @Override
    public IPage<OwnerAccountRunningWaterRecordVO> ownerAccountRunningWaterPageList(PageOwnerAccountRunningWaterParam param) {
        Page<OwnerAccountRunningWaterRecordVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.ownerAccountRunningWaterPageList(page, param);
    }
}
