package com.clx.performance.vo.pc.owner.settle;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;


@Getter
@Setter
@ToString
@NoArgsConstructor
public class PageOwnerSettlementOwnerDetailVO {

    @ApiModelProperty(value="货主用户编号",example = "4174174")
    private Long ownerUserNo;

    @ApiModelProperty(value="货主名称",example = "张三")
    private String ownerName;

    @ApiModelProperty(value="结算单号",example = "41441")
    private String settlementNo;

    @ApiModelProperty(value="结算子单号",example = "41441")
    private String settlementSubNo;

    @ApiModelProperty(value="运单编号",example = "41441")
    private String childNo;


    @ApiModelProperty(value="订单编号",example = "41441")
    private String orderNo;


    @ApiModelProperty(value="货物名称",example = "货物名称")
    private String goodsName;

    @MoneyOutConvert
    @ApiModelProperty(value="平台运费单价",example = "10.2")
    private BigDecimal freightPrice;

    @ApiModelProperty(value="实际净重（吨）",example = "2.3")
    private BigDecimal weight;

    @MoneyOutConvert
    @ApiModelProperty(value="实际运费",example = "2.52")
    private BigDecimal freight;

    @MoneyOutConvert
    @ApiModelProperty(value="损耗单价",example = "1.2")
    private BigDecimal lossPrice;

    @ApiModelProperty(value="货损吨数（吨）",example = "1.02")
    private BigDecimal lossWeight;

    @MoneyOutConvert
    @ApiModelProperty(value="货损金额",example = "2.3")
    private BigDecimal lossFreight;

    @MoneyOutConvert
    @ApiModelProperty(value="预付运费金额",example = "1.2")
    private BigDecimal prepayFreight;

    @MoneyOutConvert
    @ApiModelProperty(value="结算金额",example = "1.2")
    private BigDecimal settlementFreight;

    @MoneyOutConvert
    @ApiModelProperty(value="开票金额",example = "2.1")
    private BigDecimal invoiceFreight;

    @ApiModelProperty(value="开票标识：1网运单 2普通单",example = "普通单")
    private String invoiceTypeMsg;

    @ApiModelProperty(value="尾款状态 0-否,1-是,2-无需支付",example = "无需支付")
    private String finalPaymentStatusMsg;

    @ApiModelProperty(value="开票状态 0-否,1-是",example = "是")
    private String invoiceStatusMsg;

    @ApiModelProperty(value="创建时间",example = "2013-01-01 00:00:00")
    private String createTime;

}