package com.clx.performance.param.pc;

import com.msl.common.convertor.type.MoneyInConvert;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;


@ApiModel(description = "货主提现")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class OwnerCaseOutParam {

    @ApiModelProperty(value = "货主用户编号", example = "123")
    private Long ownerUserNo;

    @ApiModelProperty(value = "提现金额（元）", example = "1.23")
    private BigDecimal caseOutBalance;

    @ApiModelProperty(value = "账户类型： 1：保证金 2：预付运费", example = "1")
    private Integer accountType;

    @ApiModelProperty(value = "提现银行", example = "浙江银行")
    private String caseOutBank;

    @ApiModelProperty(value = "提现银行卡号", example = "62213545878787")
    private String caseOutBankNumber;

}