package com.clx.performance.vo.pc;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;


@Getter
@Setter
@NoArgsConstructor
public class OrderChildPoundAuditDetailVO {

    @Schema(description="运单编号",example = "41441")
    private String childNo;

    @Schema(description="装货净重",example = "10")
    private BigDecimal loadNet;

    @Schema(description="卸货净重",example = "41")
    private BigDecimal unloadNet;

    @Schema(description = "装货毛重", example = "10")
    private BigDecimal loadRough;

    @Schema(description = "装货皮重", example = "10")
    private BigDecimal loadTare;

    @Schema(description="卸货毛重",example = "41")
    private BigDecimal unloadRough;

    @Schema(description="卸货皮重",example = "41")
    private BigDecimal unloadTare;

    @Schema(description = "卸货磅单编号", example = "url")
    private String unloadPoundNo;

    @Schema(description="审核状态 0 待审核 1 审核通过 2 审核驳回",example = "1")
    private Integer status;

    @Schema(description="备注",example = "41441")
    private String remark;

    @Schema(description="审核驳回类型：1装车 2卸车 3装车+卸车",example = "1")
    private Integer rejectType;

    @Schema(description="装车磅单图片")
    private List<String> loadImages;

    @Schema(description="卸车磅单图片")
    private List<String> unloadImages;

    @Schema(description="创建时间",example = "2012-01-01 01:10:10")
    private String createTime;

    @Schema(description="车牌号")
    private String truckNo;

    @Schema(description = "装车时间")
    private String loadTime;

    @Schema(description = "卸车时间")
    private String unloadTime;

    @Schema(description = "发货地址")
    private String sendAddress;

    @Schema(description = "收货地址")
    private String receiveAddress;

    @Schema(description = "装车识别毛重参考")
    private BigDecimal loadGrossWeight;

    @Schema(description = "装车识别皮重参考")
    private BigDecimal loadTareWeight;

    @Schema(description = "卸车识别毛重参考")
    private BigDecimal unloadGrossWeight;

    @Schema(description = "卸车识别皮重参考")
    private BigDecimal unloadTareWeight;

    @Schema(description="合作公司id")
    private Integer cooperativeCompaniesId;

    @Schema(description="合作公司名称")
    private String cooperativeCompaniesName;
}