package com.clx.performance.vo.feign;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

/**
 * @Description
 * @Author aiqingguo
 * @Date 2023-10-19 16:33:52
 * @Version 1.0
 */
@Getter
@Setter
public class OwnerInfoVO {

    @Schema(description="用户编号")
    private Long userNo;
    
    @Schema(description="姓名")
    private String name;
    
    @Schema(description="手机号码")
    private String mobile;
    
    @Schema(description="货主类型  1企业  2个人")
    private Integer ownerType;

    @Schema(description="所属银行")
    private String ownerAccountBank;

    @Schema(description="开户行")
    private String ownerOpenBank;

    @Schema(description="开户行号")
    private String ownerOpenBankNumber;

    @Schema(description="户名")
    private String ownerAccountName;

    @Schema(description="银行账户")
    private String ownerBankAccount;

    @Schema(description="结算账期  1拉运完成结  2月结")
    private Integer settlementAccountPeriod;

    @Schema(description="结算方式  1装车净重 2卸车净重")
    private Integer settlementWay;

    @Schema(description="冻结方式  1自动冻结 2手动冻结")
    private Integer freezeSetting;

    @Schema(description="公司名称")
    private String companyName;

    @Schema(description="法人姓名")
    private String legalName;

    @Schema(description="法人身份证")
    private String legalCardNo;
    @Schema(description = "法人手机号", example = "")
    private String legalMobile;
    @Schema(description="营业执照图片地址")
    private String companyBusinessImg;

    @Schema(description="营业执照编号")
    private String companyBusinessNo;


    @Schema(description="公司税号")
    private String companyTaxCode;

    @Schema(description="公司地址")
    private String companyAddress;

    @Schema(description="公司联系电话")
    private String companyTelephone;

    @Schema(description="公司银行账户")
    private String companyBankAccount;

    @Schema(description="公司开户行")
    private String companyOpenBank;

    @Schema(description="统一社会信用代码")
    private String companyGroupCode;

    @Schema(description="联系人")
    private String contactsName;
    @Schema(description="联系电话")
    private String contactsTelephone;
    @Schema(description="联系地址")
    private String contactsAddress;
    @Schema(description="网络货运货主编码")
    private String transportOwnerCode;

    @Schema(description="创建时间")
    private String createTime;

}
