package com.clx.performance.param.open;

import com.msl.common.convertor.type.MoneyInConvert;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.DecimalMax;
import java.math.BigDecimal;


@Schema(description = "货主充值")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class OpenOwnerTopUpParam {

    @Schema(description = "货主用户编号", example = "123")
    private Long ownerUserNo;

    @Schema(description = "充值金额（元）", example = "1.23")
    @MoneyInConvert
    @DecimalMax(value = "9999999999.99",message = "金额不得大于9999999999.99元")
    private BigDecimal topUpBalance;

    @Schema(description = "账户类型： 1：保证金 2：预付运费", example = "1")
    private Integer accountType;

    @Schema(description = "打款银行", example = "浙江银行")
    private String drawingBank;

    @Schema(description = "打款银行卡号", example = "62213545878787")
    private String drawingBankNumber;

    @Schema(description = "打款凭证", example = "/a.png")
    private String drawingProof;



}