package com.clx.performance.service.impl.breakcontract;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.breakcontract.BreakContractSettlementOwnerDetailDao;
import com.clx.performance.model.breakcontract.BreakContractSettlementOwnerDetail;
import com.clx.performance.param.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerDetailParam;
import com.clx.performance.service.breakcontract.BreakContractSettlementOwnerDetailService;
import com.clx.performance.struct.breakcontract.BreakContractSettlementOwnerDetailStruct;
import com.clx.performance.utils.excel.ExcelData;
import com.clx.performance.utils.excel.ExcelField;
import com.clx.performance.utils.excel.ExcelSheet;
import com.clx.performance.utils.excel.ExcelUtil;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerDetailVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Service
@Slf4j
@AllArgsConstructor
public class BreakContractSettlementOwnerDetailServiceImpl  implements BreakContractSettlementOwnerDetailService {

    private final BreakContractSettlementOwnerDetailDao breakContractSettlementOwnerDetailDao;
    private final BreakContractSettlementOwnerDetailStruct breakContractSettlementOwnerDetailStruct;

    @Override
    public IPage<PageCarrierBreakContractSettlementOwnerDetailVO> pageCarrierBreakContractSettlementOwnerDetailList(PageCarrierBreakContractSettlementOwnerDetailParam param) {
        IPage<BreakContractSettlementOwnerDetail> breakContractSettlementDriverDetail = breakContractSettlementOwnerDetailDao.pageCarrierBreakContractSettlementOwnerDetailList(param);
        List<PageCarrierBreakContractSettlementOwnerDetailVO> list = breakContractSettlementOwnerDetailStruct.covertToCarrierList(breakContractSettlementDriverDetail.getRecords());
        return new Page<PageCarrierBreakContractSettlementOwnerDetailVO>().setRecords(list).setTotal(breakContractSettlementDriverDetail.getTotal()).setPages(breakContractSettlementDriverDetail.getPages());

    }

    @Override
    public SXSSFWorkbook exportCarrierBreakContractSettlementOwnerDetailList(PageCarrierBreakContractSettlementOwnerDetailParam param) {
        param.setPage(1);
        param.setPageSize(1000000);
        IPage<PageCarrierBreakContractSettlementOwnerDetailVO> settlementOwnerDetail = pageCarrierBreakContractSettlementOwnerDetailList(param);

        List<PageCarrierBreakContractSettlementOwnerDetailVO> list = settlementOwnerDetail.getRecords();

        // 组装表头
        List<ExcelField> fieldList = new ArrayList<>();
        fieldList.add(new ExcelField(0, "序号", "index", 2000));
        fieldList.add(new ExcelField(1, "违约单号", "breakNo", 5000));
        fieldList.add(new ExcelField(2, "订单编号", "orderNo", 5000));
        fieldList.add(new ExcelField(3, "公司编号", "ownUserNo", 5000));
        fieldList.add(new ExcelField(4, "公司名称", "ownerName", 5000));

        fieldList.add(new ExcelField(5, "违约方", "breakContractPartyType", 5000));
        fieldList.add(new ExcelField(6, "违约金额", "figure", 5000));
        fieldList.add(new ExcelField(7, "创建人", "createName", 5000));
        fieldList.add(new ExcelField(8, "创建时间", "createTime", 5000));
        fieldList.add(new ExcelField(9, "结算单号", "settlementNo", 5000));


        // 组装数据
        List<List<ExcelData>> dataList = new ArrayList<>();
        for (int i=0; i<list.size(); i++){

            PageCarrierBreakContractSettlementOwnerDetailVO dto = list.get(i);
            List<ExcelData> rowData = new ArrayList<>();

            rowData.add(new ExcelData(i+1));
            rowData.add(new ExcelData(dto.getBreakNo()));
            rowData.add(new ExcelData(dto.getOrderNo()));
            rowData.add(new ExcelData(dto.getOwnerUserNo()+""));
            rowData.add(new ExcelData(dto.getOwnerName()));

            rowData.add(new ExcelData(dto.getBreakContractPartyTypeMsg()));
            rowData.add(new ExcelData(dto.getFigure().movePointLeft(2)));
            rowData.add(new ExcelData(dto.getCreateName()));
            rowData.add(new ExcelData(dto.getCreateTime()));
            rowData.add(new ExcelData(dto.getSettlementNo()));

            dataList.add(rowData);
        }

        ExcelSheet excelSheet = new ExcelSheet("货主违约计费", "货主违约计费", fieldList, dataList);

        //创建excel
        return ExcelUtil.create(excelSheet);
    }
}
