package com.clx.performance.controller.pc;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.PagePendingFreightParam;
import com.clx.performance.service.PendingFreightService;
import com.clx.performance.vo.pc.PagePendingFreightVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName PendingFreightController
 * @Description
 * @Author kavin
 * @Date 2024/10/21 9:47
 * @Version 1.0
 */


@Slf4j
@RestController
@RequestMapping(value="/pc/pendingFreight")
@Validated
@Tag(name = "挂单运费")
@AllArgsConstructor
public class PendingFreightController {


    private final PendingFreightService pendingFreightService;

    @Operation(summary = "查看挂单运费分页列表", description = "<br>By:刘海泉")
    @PostMapping("/pagePendingFreight")
    @UnitCovert(param = false)
    public Result<PageData<PagePendingFreightVO>> pagePendingFreight(@RequestBody @Validated PagePendingFreightParam param) {
        IPage<PagePendingFreightVO> page = pendingFreightService.pagePendingFreight(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @Operation(summary = "导出挂单运费", description = "<br>By:刘海泉")
    @PostMapping("/exportPendingFreight")
    @UnitCovert(param = false)
    public void exportPendingFreight(@RequestBody @Validated PagePendingFreightParam param, HttpServletResponse response) throws Exception {
        SXSSFWorkbook workbook = pendingFreightService.exportPendingFreight(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
    }



}
