package com.clx.performance;

import com.clx.order.feign.OrderFeign;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.mapper.OrderGoodsMapper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.math.BigDecimal;

@SpringBootTest
@RunWith(SpringRunner.class)
public class JobTest {

    @Autowired
    private OrderFeign orderFeign;

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Test
    public void test1() {
        Message message = MessageBuilder.withBody("PT2023091900049".getBytes()).build();
        message.getMessageProperties().setExpiration("10000");
        rabbitTemplate.send(
                RabbitKeyConstants.ORDER_GOODS_ON_EXCHANGE, RabbitKeyConstants.ORDER_GOODS_ON_ROUTE_KEY, message
        );
    }
}
