package com.clx.performance.struct;

import com.clx.performance.model.OrderGoods;
import com.clx.performance.vo.feign.OrderGoodsFeignVO;
import com.clx.performance.vo.pc.DriverFreightPriceVO;
import com.clx.performance.vo.pc.OrderGoodsPendingVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.clx.performance.vo.pc.linewarn.LineWarnTraceVO;
import com.msl.common.utils.DateStructUtil;
import com.msl.common.utils.DateUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.List;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {DateUtils.class})
public interface OrderGoodsStruct {


    OrderGoodsVO convert(OrderGoods orderGoods);

    List<OrderGoodsFeignVO> convertList(List<OrderGoods> orderGoods);

    @Mapping(target = "sendAddress", source = "sendAddressShorter")
    @Mapping(target = "receiveAddress", source = "receiveAddressShorter")
    LineWarnTraceVO convertLineWarnTraceVO(OrderGoods item);

    List<DriverFreightPriceVO> convertDriverFreightList(List<OrderGoods> orderGoods);

    List<OrderGoodsPendingVO> convertOrderGoodsPendingList(List<OrderGoods> orderGoods);


}
