package com.clx.performance.sqlProvider.settle;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.owner.PageCarrierSettlementPlatformServiceFeeParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class SettlementPlatformServiceFeeSqlProvider {

    private static final String TABLE = "settlement_platform_service_fee";

    public String pageByParam(@Param("page") Page page, @Param("param") PageCarrierSettlementPlatformServiceFeeParam param) {

        return new SQL(){{

            SELECT("*");
            FROM(TABLE);

            if (StringUtils.isNotBlank(param.getChildNo())) {WHERE("child_no = #{param.childNo}");}
            if (StringUtils.isNotBlank(param.getDriverName())) {WHERE("driver_name like CONCAT(#{param.driverName},'%')");}
            if (StringUtils.isNotBlank(param.getDriverMobile())) {WHERE("driver_mobile = #{param.driverMobile}");}
            if (Objects.nonNull(param.getDriverUserNo())) {WHERE("driver_user_no = #{param.driverUserNo}");}


            if (Objects.nonNull(param.getBeginTime())) {WHERE("create_time >= #{param.beginTime}");}
            if (Objects.nonNull(param.getEndTime())) {WHERE("create_time <= #{param.endTime}");}

            ORDER_BY("id desc");
        }}.toString();
    }

}
