package com.clx.performance.sqlProvider;

import cn.hutool.core.util.ObjectUtil;
import com.clx.order.enums.OrderEnum;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.OwnerAccount;
import com.clx.performance.param.pc.PageOwnerAccountListParam;
import com.msl.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

public class OwnerAccountSqlProvider {

    public String pageList(@Param("param") PageOwnerAccountListParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.owner_user_no," +
                    " a.owner_user_name, a.mobile, a.account_type, " +
                    " a.account_balance,a.usable_balance,a.frozen_balance,a.create_by,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time");
            FROM("owner_account a");


            if (StringUtils.isNotBlank(param.getOwnerUserNo())) {
                WHERE("a.owner_user_no = #{param.ownerUserNo}");
            }
            if (StringUtils.isNotBlank(param.getMobile())) {
                WHERE("a.mobile = #{param.mobile}");
            }
            if (ObjectUtil.isNotNull(param.getAccountType())) {
                WHERE("a.account_type = #{param.accountType}");
            }
            if (StringUtils.isNotBlank(param.getOwnerUserName())) {
                WHERE("a.owner_user_name like CONCAT('%',#{param.ownerUserName},'%')");
            }
            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }

    public String addAccount(@Param("account") OwnerAccount account, @Param("now")LocalDateTime now) {
        StringBuffer sqlList = new StringBuffer();

        sqlList.append("update owner_account set usable_balance = usable_balance +" +
                account.getUsableBalance() + ",account_balance = account_balance +"
                + account.getAccountBalance()+
                ",modified_time='" + DateUtils.formatDateTime(now, "yyyy-MM-dd HH:mm:ss") +"'"
                + " where id = " + account.getId() + " and modified_time = '" + DateUtils.formatDateTime(account.getModifiedTime(), "yyyy-MM-dd HH:mm:ss").get()+"'"
        );

        return sqlList.toString();
    }

    public String subAccount(@Param("account") OwnerAccount account, @Param("now")LocalDateTime now) {
        StringBuffer sqlList = new StringBuffer();

        sqlList.append("update owner_account set usable_balance = usable_balance -" +
                account.getUsableBalance() + ",frozen_balance = frozen_balance +"
                + account.getFrozenBalance() +",account_balance = account_balance -" + account.getFrozenBalance()
                + ",modified_time='" + DateUtils.formatDateTime(now, "yyyy-MM-dd HH:mm:ss").get()+"'"
                + " where id = " + account.getId() + " and modified_time = '" + DateUtils.formatDateTime(account.getModifiedTime(), "yyyy-MM-dd HH:mm:ss").get()+"'"
        );

        return sqlList.toString();
    }

}
