package com.clx.performance.service.impl.broker;

import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.dao.settle.SettlementDriverDetailDao;
import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.enums.settle.SettlementOwnerDetailEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.service.broker.OrderChildBrokerMqHandlerService;
import com.clx.performance.service.broker.OrderChildBrokerService;
import com.clx.performance.vo.mq.broker.BrokerOrderChildSyncMqParam;
import com.clx.performance.vo.mq.broker.BrokerOrderChildUpdateMqParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

@Slf4j
@Service
public class OrderChildBrokerMqHandlerServiceImpl implements OrderChildBrokerMqHandlerService {
    @Autowired
    private OrderGoodsDao orderGoodsDao;
    @Autowired
    private OrderChildDao orderChildDao;
    @Autowired
    private SettlementOwnerDetailDao settlementOwnerDetailDao;
    @Autowired
    private SettlementDriverDetailDao settlementDriverDetailDao;
    @Autowired
    private OrderChildBrokerService orderChildBrokerService;

    @Override
    public void orderChildSync(BrokerOrderChildSyncMqParam mq) {
        String childNo = mq.getChildNo();
        Integer invoiceType = mq.getInvoiceType();

        OrderChild orderChild = orderChildDao
                .getByChildNo(childNo).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        OrderGoods orderGoods = orderGoodsDao
                .getByOrderGoodsNo(orderChild.getOrderGoodsNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        SettlementOwnerDetail settlementOwnerDetail = settlementOwnerDetailDao
                .getByChildNo(orderChild.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        SettlementDriverDetail settlementDriverDetail = settlementDriverDetailDao
                .getByChildNo(orderChild.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        // 更新状态
        settlementOwnerDetail.setInvoiceTypeStatus(SettlementOwnerDetailEnum.InvoiceTypeStatus.PROCESSING.getCode());
        settlementOwnerDetailDao.updateInvoiceTypeStatus(settlementOwnerDetail);

        settlementOwnerDetail.setInvoiceType(invoiceType);
        try{
            // 同步broker
            orderChildBrokerService.orderChildSync(orderChild, orderGoods, settlementOwnerDetail, settlementDriverDetail);
        } catch (Exception e) {
            log.info("同步无车承运失败, child:{}, msg:{}", orderChild.getChildNo(), ExceptionUtils.getStackTrace(e));
        }

    }
    @Override
    public void orderChildUpdate(BrokerOrderChildUpdateMqParam mq) {
        String childNo = mq.getChildNo();

        OrderChild orderChild = orderChildDao
                .getByChildNo(childNo).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        OrderGoods orderGoods = orderGoodsDao
                .getByOrderGoodsNo(orderChild.getOrderGoodsNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        SettlementOwnerDetail settlementOwnerDetail = settlementOwnerDetailDao
                .getByChildNo(orderChild.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        SettlementDriverDetail settlementDriverDetail = settlementDriverDetailDao
                .getByChildNo(orderChild.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        if (Objects.equals(settlementOwnerDetail.getReportFlag(), com.clx.order.enums.OrderEnum.ReportFlag.NO.getCode())){
            return;
        }

        try{
            // 更新broker
            orderChildBrokerService.orderChildUpdate(orderChild, orderGoods, settlementOwnerDetail, settlementDriverDetail);
        } catch (Exception e) {
            log.info("更新无车承运失败, child:{}, msg:{}", orderChild.getChildNo(), ExceptionUtils.getStackTrace(e));
        }

    }

}
