package com.clx.performance.service.impl;

import com.clx.performance.dao.PlatformServiceFeeConfigDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.PlatformServiceFeeConfig;
import com.clx.performance.param.pc.carrier.SavePlatformServiceFeeConfigParam;
import com.clx.performance.service.PlatformServiceFeeConfigService;
import com.clx.performance.struct.PlatformServiceFeeConfigStruct;
import com.clx.performance.vo.feign.PlatformServiceFeeConfigFeignVO;
import com.clx.performance.vo.pc.carrier.settle.CarrierPagePlatformServiceFeeConfigVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;


/**
 * @author yangqifa
 */
@Slf4j
@Service
@AllArgsConstructor
public class PlatformServiceFeeConfigServiceImpl implements PlatformServiceFeeConfigService {

    private final PlatformServiceFeeConfigDao platformServiceFeeConfigDao;

    private final PlatformServiceFeeConfigStruct platformServiceFeeConfigStruct;

    @Override
    public CarrierPagePlatformServiceFeeConfigVO listPlatformServiceFeeConfig() {
        PlatformServiceFeeConfig config = platformServiceFeeConfigDao.listPlatformServiceFeeConfig();
        return platformServiceFeeConfigStruct.convertToDetail(config);
    }

    @Override
    public CarrierPagePlatformServiceFeeConfigVO getPlatformServiceFeeConfigDetail(int id) {
        PlatformServiceFeeConfig config = platformServiceFeeConfigDao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        return platformServiceFeeConfigStruct.convertToDetail(config);
    }

    @Override
    public void updatePlatformServiceFeeConfig(SavePlatformServiceFeeConfigParam param) {
        PlatformServiceFeeConfig config = new PlatformServiceFeeConfig();
        config.setId(param.getId());
        config.setOrderQuotationType(param.getOrderQuotationType());
        config.setDeposit(param.getDeposit());
        config.setServiceFeeRate(param.getServiceFeeRate());
        platformServiceFeeConfigDao.updatePlatformServiceFeeConfig(config);
    }

    @Override
    public PlatformServiceFeeConfigFeignVO getConfig() {
        return platformServiceFeeConfigStruct
                .convertPlatformServiceFeeConfigFeignVO(platformServiceFeeConfigDao.listPlatformServiceFeeConfig());
    }
}
