package com.clx.performance.model.loan;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-02-21
 * Time 19:58
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_child_loan_retry_record")
public class OrderChildLoanRetryRecord implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("owner_user_no")
    @ApiModelProperty("货主编号")
    private Long ownerUserNo;

    @TableField("settlement_driver_id")
    @ApiModelProperty("车主计费主键")
    private Integer settlementDriverId;

    @TableField("settlement_owner_id")
    @ApiModelProperty("货主计费主键")
    private Integer settlementOwnerId;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
